BEM.DOM.decl('select', {

    onSetMod: {
        js: {
            inited: function() {
                this.__base.apply(this, arguments);

                /*
                @anyakey для https://st.yandex-team.ru/DIRECT-64959
                В ISLCOMPONENTS-60 вкрутили костыль, так как если в попапе 1 селект и он переключался
                с большого текста на маленький, неправильно позиционировался хвостик попапа
                решили с @cyn это оторвать, а если возникнет проблема,
                решать на уровне попапа (см. popup_content-adaptive_yes)
                * */
                this.un('change', this._redrawParentPopup);
            }
        }
    },

    /**
     * возвращает индекс выбранного элемента селекта
     * @returns {Number}
     */
    getSelectedIndex: function() {

        return this._getSelectedIndex();

    },

    /**
     * Костыль для включения/отключения определенного option по его value
     * @param {String} val
     * @param {Boolean} [state] если параметр не указан, будет переключение при каждом вызове
     * @returns {BEM.DOM}
     */
    toggleOptionState: function(val, state) {
        var option = this.elem('control').find('[value=' + val + ']');

        // Если state не передан - переворачиваем (!) текущее значение.
        state = typeof state === 'boolean' ? state : !option.attr('disabled');

        option
            .attr('disabled', state)
            .prop('checked', false);

        if (this._popup) {
            if (this._popup.isShown()) {
                return this.redraw().open();
            } else {
                return this.redraw();
            }
        } else {
            return this;
        }
    },

    /**
     * Возвращает текст выбранного элемента селекта
     * @returns {String}
     */
    getSelectedOptionText: function() {

        return this.elem('control').find('option').eq(this._getSelectedIndex()).text();

    },

    /**
     * Задаёт возвращает текст кнопки
     * Если есть модификатор cut-button, то его значение задает длину текста на кнопке
     * @param {String} [text]
     * @returns {String|undefined}
     * @protected
     */
    _setButtonText: function(text) {
        if (typeof text === 'undefined') {
            return this.__base.call(this);
        }

        text = u.escapeHTML(text);

        this.hasMod('cut-button') && (text = $('<div>').html(u.hellipCut(text, +this.getMod('cut-button'))).text());

        // evaluate html entities
        text = $('<div>').html(text).text();

        return this.__base.call(this, text);
    },

    /**
     * Устанавливает/возвращает номер выбранного элемента
     * @protected
     * @param {Number} [index]
     * @returns {Number}
     */
    _selectedIndex: function(index) {
        var prevIdx = this._getSelectedIndex(),
            baseResult = this.__base.call(this, index);

        // fix перерисовки текста кнопки (библиотечный блок для native control на мобилках не перерисовывает кнопку)
        if (this._useNativeControl() && arguments.length > 0 && index !== prevIdx) {
            this._setButtonText(this._getSelectedText());
        }

        return baseResult;
    },

    /**
     * Устанавливает новое содержимое селекта
     * Дополнительно задаёт контент для ненативного селекта
     * @param {[Object]} data
     * @returns {BEM.DOM}
     */
    setOptions: function(data) {
        var index;

        this.__base.call(this, data);

        if (!this._useNativeControl() && Array.isArray(data)) {
            index = 0;

            this._items.length && data.forEach(function(it) {
                it.item === 'option' && typeof it.content === 'object' &&
                    this.findElem(this._items.eq(index++), 'text').html(BEMHTML.apply(it.content));
            }, this);
        }

        return this;
    },

    /**
     * В связи с задачей DIRECT-48948
     * @param {jQuery.Event} e
     * @private
     * @override
     */
    _onMouseDown: function(e) {
        this._useNativeControl() || this._isControlFocused() && e.preventDefault();
    }

});
