BEM.decl({ block: 'suggest', modName: 'empty-state', modVal: 'enabled' }, {

    _onData: function(data) {
        if (!data.items.length && !this._hideEmpty) {
            var popup = this._popup;

            this.trigger('data-received', data);

            this._items = [];
            popup.setContent(
                BEMHTML.apply({
                    block: 'suggest',
                    // ставим mods, чтобы отработал bemhtml
                    mods: { 'empty-state': 'enabled' },
                    elem: 'empty',
                    // ставим elemMods, чтобы на элементе были классы
                    elemMods: { 'empty-state': 'enabled' }
                }));
            this._input.hasMod('focused') ? this.redraw() : this._hide();

            return;
        } else {
            this._hideEmpty = false;
            this.__base.apply(this, arguments);
        }
    },

    _hideEmpty: null,

    /**
     * Задает _hideEmpty, если есть необходимость не показывать соообщение
     * @param {Boolean} state
     */
    setHideEmpty: function(state) {
        this._hideEmpty = state;
    }

});
