BEM.decl({ block: 'suggest', modName: 'with-select-all', modVal: 'yes' }, {

    onSetMod: {

        js: function() {
            var _this = this;

            this.__base.apply(this, arguments);

            this.on('created', function() {
                _this._popup.domElem.on('mousedown', '.suggest__select-all-link', function() {
                    _this._provider.getAllMatched(_this._input.val(), 0, function(data) {
                        _this.trigger('select-all', {
                            items: data.items.map(function(item) { return item[1] })
                        });
                    });
                });
            });
        }

    },

    _onData: function(data) {
        this.__base.apply(this, arguments);

        if (!this._popup) {
            return;
        }

        var total = data.total,
            content = this._popup.findElem('content');

        if (!total || content.find('.suggest__select-all').length) return;

        BEM.DOM.prepend(
            content,
            BEMHTML.apply({
                block: this.__self.getName(),
                elem: 'select-all',
                elemMods: this.getMods(),
                count: total
            }));
    }

});
