/**
 * Саджест для инпута
 * @override
 * {Boolean} [this.params.autoEnterFirstItem] – автоматический выбор первого элемента саджеста
 */
BEM.decl('suggest', {

    onSetMod: {

        js: function() {
            this.__base.apply(this, arguments);

            if (this.params.autoEnterFirstItem) {
                this.on('update-items', function() {
                    this._items && this._items.length &&
                        this._onEnterItem(this._items[0], true);
                }, this);
            }
        }

    },

    /**
     * Обработчик события фокуса инпута
     * @override
     * @private
     */
    _onFocus: function() {
        this.params.autoEnterFirstItem && this._request();
    },

    /**
     * Создаёт или возвращает ранее созданного провайдера
     * @override
     * @returns {BEM}
     */
    _getProvider: function() {
        if (this._provider) return this._provider;

        if (this.params.provider) {
            return (this._provider = this.params.provider);
        } else {
            this.__base.apply(this, arguments);
        }
    },

    /**
     * Отображает саджест
     * NOTICE: попап должен позиционироваться по ширине контрола
     * @override
     */
    _show: function() {
        var rect = this._owner.domElem[0].getBoundingClientRect();

        this._popup.domElem.css({
            left: rect.left + $(document).scrollLeft(),
            width: rect.width
        });

        this.__base.apply(this, arguments);
    },

    /**
     * Обрабочик события получения данных
     * NOTICE: прокидываем в meta модификатор для _buildItems
     * @param {Object} data
     * @private
     */
    _onData: function(data) {
        data.meta = data.meta || {};
        data.meta.mods = this.getMods();

        if (this._popup) {
            this.__base.apply(this, arguments);
        }
    },

    /**
     * Обработчик выбора элемента
     * @override
     */
    _onSelectItem: function(item, byKeyboard) {
        item && this.__base.apply(this, arguments);
    },

}, {
    /**
     * Возвращает BEMJSON для popup
     * NOTICE: избавился от "костыля" (в терминологии Лего) с left
     * @returns {Object}
     * @override
     */
    _buildPopup: function(suggestMods) {
        return {
            block: 'popup',
            mods: { autoclosable: 'no', adaptive: 'no', animate: 'no' },
            mix: [{ block: 'suggest', mods: suggestMods }],
            content: {
                elem: 'content',
                mix: [{ block: 'suggest', elem: 'content' }]
            }
        };
    },

    /**
     * Создаёт элементы подсказки.
     * NOTICE: прокидываем модификаторы блока
     * @override
     * @returns {Object} BEMJSON
     */
    _buildItems: function(items, meta) {
        var groupsBEMJSON = this.__base.apply(this, arguments),
            mods = meta && meta.mods;

        return groupsBEMJSON.map(function(group) {
            group.mods = mods;

            return group;
        });
    }
});
