BEM.DOM.decl({ name: 'tabs-menu', modName: 'with-confirm', modVal: 'yes' }, {
     /**
     *
     * @param {JQuery} elem
     * @returns {Promise}
     * @private
     */
    _askConfirm: function(elem) {
        var prev = this.getActive(),
            deferred = $.Deferred();

        this.trigger('ask-confirm', {
            prevIndex: this.indexOfTab(prev),
            current: elem,
            prev: prev,
            currentIndex: this.indexOfTab(elem),
            deferred: deferred
        });

        return deferred.promise()
    },

    /**
     * Активирует вкладку относительно текущей активной, игнорируя отключенные и не интерактивные.
     * @override
     * @private
     * @param {Number} delta Показывает направление и "дальность" активации. Например, если `delta = -1`, то
     * активируется предыдущая вкладка, если `delta = 1`, то следующая.
     */
    _activateRelative: function(delta) {
        var tabs = this.elem('tab', 'interactive', 'yes').not(this.findElem('tab', 'disabled', 'yes')),
            newIndex = $.inArray(this.getActive().get(0), tabs) + delta,
            ctx = this,
            promise;

        if (newIndex < 0 || newIndex > tabs.length) {
            return;
        }

        promise = this._askConfirm(tabs.eq(newIndex));

        promise.done(function() {
            ctx.setMod(tabs.eq(newIndex), 'active', 'yes');
        });
    },

    /**
     * Обработчик клика по вкладке.
     *
     * @override
     * @private
     * @param {$.Event} e
     */
    _onTabClick: function(e) {
        var elem = this._getTabByElem($(e.target)),
            ctx = this,
            promise = this._askConfirm(elem);

        promise.done(function() {
            ctx.setMod(elem, 'active', 'yes');
        });
    }
});
