/**
 * Абстрактная view model
 */
BEM.MODEL.decl('view-model', {

}, {
    /**
     * Инициализирует view model на основе data model
     * @param {BEM.MODEL} dataModel – data model
     */
    init: function(dataModel) {
        var deps = {},
            _this = this;

        this._dataModel = dataModel;

        Object.keys(this.fieldsDecl).forEach(function(field) {
            var decl = this.fieldsDecl[field],
                sources = decl.sources;

            if (!sources) return;

            if ($.isFunction(sources.mapping)) {
                decl.calculate = function() {
                    return sources.mapping(dataModel);
                };
            } else if (typeof sources.mapping === 'string') {
                (sources.deps || (sources.deps = [])).push(sources.mapping);
            }

            sources.deps && sources.deps.forEach(function(dataField) {
                (deps[dataField] || (deps[dataField] = [])).push(field);
            });
        }, this);

        dataModel.on('change', function() {
            var viewFieldsToUpdate = this.changed.reduce(function(viewFields, field) {
                var fieldDeps = deps[field];

                if (fieldDeps) {
                    for (var j = 0; j < fieldDeps.length; j++) {
                        viewFields[fieldDeps[j]] = true;
                    }
                }

                return viewFields;
            }, {});

            _this.updateFromData(Object.keys(viewFieldsToUpdate));
        });

        this.updateFromData();
        this.fix();
    },

    /**
     * Обновляет поля view model на основе data model
     * @param {Array} [fields] – список полей, которые надо обновить (по умолчанию все)
     * @private
     */
    updateFromData: function(fields) {
        fields || (fields = Object.keys(this.fieldsDecl));

        fields.forEach(function(field) {
            var decl = this.fieldsDecl[field],
                sources = decl.sources;

            if (!sources) return;

            if ($.isFunction(sources.mapping)) {
                this.trigger(field, 'change', { value: this.get(field) });
            } else if (typeof sources.mapping === 'string') {
                this.set(field, this._dataModel.get(sources.mapping));
            }
        }, this);
    }

});
