#Абстрактная view model

Базовый класс для наследования.
Подписывается на изменение зависимых полей модели данных и в соответствии с правилами маппинга преобразует модель данных
к модели представления.
Для инициализации модели представления необходимо вызвать метод init и передать в качестве параметра модель данных.

##Примеры:

<pre><code>
'title': {
    type: 'string',
    // Хэш декларирующий зависимости от модели данных
    sources: {
        // Перечень полей модели данных, при изменении которых, будет тригериться изменение поля (может отсутствовать)
        deps: ['name'],
        // Правило преобразования серверных данных в поле
        mapping: function(dataModel) {
            return dataModel.getTitle();
        }
    }
},

// Идентификатор стратегии
'name': {
    type: 'string',
    sources: {
        // Правило маппинга может быть строкой, в случае однозначного соответствия поля модели данных и модели представления
        mapping: 'name'
    }
}
</code></pre>
