/**
 * Базовая модель динамических условий.
 */
BEM.MODEL.decl({ name: 'vm-dynamic-condition-bidable', baseModel: 'vm-dynamic-condition' }, {
    /**
     * цена клика на поиске
     */
    price: {
        type: 'number',
        preprocess: function(val) {
            return u.numberFormatter.clear(val);
        },
        validation: function() {
            var currency = u.consts('currencies')[this.get('currency')],
                strategy = this.get('strategy'),
                needValidFlag = (!strategy.name && !strategy.is_autobudget) ||
                    (strategy.name == 'different_places' && !strategy.is_search_stop);

            return {
                rules: {
                    lte: {
                        value: currency.MIN_PRICE,
                        text: iget2(
                            'vm-dynamic-condition-bidable',
                            'vvedeno-nekorrektnoe-znachenie-minimum',
                            'Введено некорректное значение. Минимум: {foo}',
                            {
                                foo: currency.MIN_PRICE
                            }
                        ),
                        needToValidate: function() {
                            return needValidFlag;
                        }
                    },
                    gte: {
                        value: currency.MAX_PRICE,
                        text: iget2(
                            'vm-dynamic-condition-bidable',
                            'ukazano-slishkom-bolshoe-znachenie',
                            'Указано слишком большое значение. Максимум: {foo}',
                            {
                                foo: currency.MAX_PRICE
                            }
                        ),
                        needToValidate: function(val) {
                            return needValidFlag && (val > currency.MIN_PRICE);
                        }
                    }
                }
            };
        }
    },

    /**
     * Цена клика на контекстных площадках
     */
    price_context: {
        type: 'number',
        preprocess: function(val) {
            return u.numberFormatter.clear(val);
        },
        validation: function() {
            var currency = u.consts('currencies')[this.get('currency')],
                strategy = this.get('strategy'),
                needValidFlag = (strategy.name == 'different_places' && !strategy.is_autobudget);

            return {
                rules: {
                    lte: {
                        value: currency.MIN_PRICE,
                        text: iget2(
                            'vm-dynamic-condition-bidable',
                            'vvedeno-nekorrektnoe-znachenie-minimum',
                            'Введено некорректное значение. Минимум: {foo}',
                            {
                                foo: currency.MIN_PRICE
                            }
                        ),
                        needToValidate: function() {
                            return needValidFlag;
                        }
                    },
                    gte: {
                        value: currency.MAX_PRICE,
                        text: iget2(
                            'vm-dynamic-condition-bidable',
                            'ukazano-slishkom-bolshoe-znachenie',
                            'Указано слишком большое значение. Максимум: {foo}',
                            {
                                foo: currency.MAX_PRICE
                            }
                        ),
                        needToValidate: function(val) {
                            return needValidFlag && (val > currency.MIN_PRICE);
                        }
                    }
                }
            };
        }
    },

    /**
     * стратегия кампании
     */
    strategy: {
        type: 'object',
        calculate: function() {
            return BEM.MODEL.getOne({ name: 'm-campaign' }).get('strategy')
        }
    },

    /**
     * валюта кампании
     */
    currency: {
        type: 'string',
        calculate: function() {
            return BEM.MODEL.getOne({ name: 'm-campaign' }).get('currency')
        }
    }
});
