/**
 * Базовая модель динамических условий.
 */
BEM.MODEL.decl({ name: 'vm-dynamic-condition', baseModel: 'vm-sync-dm' }, {
    /**
     * id условия
     */
    dyn_id: 'id',

    //Является ли новым, то есть еще не сохраненным на сервере
    isNew: 'boolean',

    /**
     * название условия
     */
    condition_name: 'string',

    /**
     * id группы
     */
    adgroup_id: 'string',

    /**
     * флаг - выключено ли условие
     */
    is_suspended: 'boolean',

    /**
     * список условий нацеливания
     */
    condition: {
        type: 'models-list',
        modelName: 'vm-dynamic-goal'
    },

    /**
     * флаг, говорящий о том, что сейчас нельзя сохранять условие нацеливания
     */
    cantSave: {
        type: 'boolean',
        internal: true,
        default: true
    },

    /**
     * декларация DM модели
     */
    _dmDecl: {
        type: 'object',
        internal: true,
        calculate: function() {
            return {
                name: 'dm-dynamic-condition',
                id: this.get('dyn_id')
            };
        }
    }
}, {
    /**
     * Возвращает массив используемых связок type + kind + value вложенных целей
     */
    getGoalsState: function() {
        return this.get('condition').map(function(model) {
            return model.getStateString();
        });
    }
});
