BEM.MODEL.decl('vm-dynamic-goal', {
    /**
     * значение цели
     */
    value: {
        type: 'models-list',
        modelName: 'b-dynamic-goal-edit-value',
        default: [{ value: '' }]
    },

    /**
     * Тип контента цели
     */
    type: {
        type: 'enum',
        enum: u.dynamicGroupsData.types,
        default: ''
    },

    /**
     * Вид сравнения
     */
    kind: {
        type: 'enum',
        enum: u.dynamicGroupsData.kinds,
        default: ''
    },

    /**
     * Суммарная строка состояния цели
     */
    summary: {
        type: 'string',
        dependsFrom: ['type', 'kind', 'value'],
        calculate: function() {
            return u.dynamicGroupsData.getSummaryText({
                type: this.get('type'),
                kind: this.get('kind'),
                value: this.get('value').map(function(item) { return item.get('value'); })
            });
        }
    },

    /**
     * Текстовки для типов, для формирования summary
     */
    typeTitles: {
        type: 'object',
        internal: true,
        default: u.dynamicGroupsData.typeTitles
    },

    /**
     * Текстовки для видов, для формирования summary
     */
    kindTitles: {
        type: 'object',
        internal: true,
        default: u.dynamicGroupsData.kindTitles
    },

    /**
     * правила наборов селектов в зависимости от типа
     */
    rules: {
        type: 'object',
        internal: true,
        default: {
            URL: ['exact', 'not_exact'],
            domain: ['exact', 'not_exact'],

            // DIRECT-48036: убрали для title и content операторы 'match', 'not_match'
            title: ['exact', 'not_exact'],
            content: ['exact', 'not_exact'],
            URL_prodlist: ['equals', 'not_equals']
        }
    }

}, {
    /**
     * Возвращает строку-статус выбранного type и kind, нужна для сравнений целей и условий
     */
    getStateString: function() {
        return this.get('type') + this.get('kind') + this.get('value').map(function(obj) {
            return obj.get('value');
        }).sort();
    }
});
