BEM.MODEL.decl({ name: 'vm-feed-filter', baseModel: 'vm-sync-dm' }, {

    // клиентский идентификатор фильтра (изначально соответствует реальному и не меняется в модели)
    filter_id: 'id',

    // реальный идентификатор (меняется и должен быть использован для связи с серверными ручками)
    real_filter_id: 'number',

    adgroup_id: 'string',
    adgroupModelId: 'string',
    adgroup_type: 'string',

    campaign_id: 'string',

    available: {
        type: 'boolean',
        default: false
    },

    filter_name: {
        format: u.escapeHtmlSafe,
        type: 'string'
    },

    now_optimizing_by: {
        type: 'enum',
        enum: ['', 'CPC', 'CPA']
    },

    price_cpc: 'number',

    price_cpa: 'number',

    price: 'number',

    price_context: 'number',

    tab: {
        type: 'enum',
        default: u.feedFilterData.defaultTab,
        enum: ['tree', 'condition', 'all-products']
    },

    condition: 'array',

    conditionTree: 'array',

    target_funnel: {
        type: 'string',
        default: Object.keys(u.feedFilterData.targetAudienceTitles)[0]
    },

    retargetings: {
        type: 'array',
        default: [],
        format: function(value) {
            return value.map(function(item) {
                var text = !u._.isEmpty(item) ? item.condition_name : '';

                return BEMHTML.apply({
                    tag: 'span',
                    attrs: { title: u.escapeHtmlSafe(text) },
                    content: u.hellipCut(text, 30, u.escapeHtmlSafe)
                });
            }).join('');
        }
    },

    has_default_price: {
        type: 'boolean',
        default: false
    },

    use_default_price: {
        type: 'boolean',
        default: false
    },

    is_settings_editable: {
        type: 'boolean',
        default: false
    },

    ctx_shows: 'number',

    ctx_clicks: 'number',

    ctx_ctr: 'number',

    is_price_editable: {
        type: 'boolean',
        default: false
    },

    is_suspended: {
        type: 'boolean',
        default: false
    },

    is_deleted: {
        type: 'boolean',
        default: false
    },

    /**
     * Флаг, корректны ли настройки фильтра
     * В режиме таба "Условия" фильтр считается всегда корректным
     * В режиме таба "Дерево категорий" фильтр считается некорректным если список ID категорий пуст
     */
    isIncorrect: {
        type: 'boolean',
        default: false
    },

    /**
     * стратегия кампании
     */
    strategy: {
        type: 'object',
        calculate: function() {
            return this.getDM().getStrategy();
        }
    },

    /**
     * валюта кампании
     */
    currency: {
        type: 'string',
        calculate: function() {
            return this.getDM().getCurrency();
        }
    },

    _deps: {
        type: 'object',
        calculate: function() {
            return {
                name: u.campaign.getGroupModelName(this.get('adgroup_type')),
                id: this.get('adgroupModelId')
            };
        }
    },

    _dmDecl: {
        type: 'object',
        internal: true,
        calculate: function() {
            return {
                name: 'dm-feed-filter',
                id: this.get('filter_id')
            };
        }
    }

}, {

    prepareDataFromDM: function(data) {
        return u._.extend(data, {
            conditionTree: data.condition_tree,
            tab: data.from_tab
        });
    },

    /**
     * Возвращает флаг наличия хотя бы одного id в дереве категорий
     * @returns {Boolean}
     */
    hasTreeConditionIds: function() {
        var condition = this.get('conditionTree').where({ field: 'categoryId' })[0];

        return condition && !!condition.get('value') && !!condition.get('value').length;
    },

    /**
     * Возвращает флаг является ли текущим таб "Дерево категорий"
     * @returns {Boolean}
     */
    isTreeTab: function() {
        return this.get('tab') == 'tree';
    },

    prepareDataToDM: function(data) {
        return {
            condition_tree: data.conditionTree,
            condition: data.condition,
            from_tab: data.tab
        };
    },

    getParentGroupDM: function() {
        return BEM.MODEL.getOne({
            name: u.campaign.getGroupModelName(this.get('adgroup_type')),
            id: this.get('adgroupModelId')
        });
    },

    /**
     * Возвращает массив используемых связок type + kind + value вложенных целей
     * для дальнейшей проверки на уникальность
     * конкатенирует выбранную целевую аудиторию, опции условий и ID условия ретаргетинга
     */
    getConditionsState: function() {
        var tab = this.get('tab'),
            retargeting = u._.isEmpty(this.get('retargetings')) ? '' : this.get('retargetings')[0].ret_cond_id,
            states = [];

        if (tab == 'all-products') {
            states.push(this.get('target_funnel').get('target_funnel') + retargeting);
        } else {
            var conditions = tab == 'tree' ? this.get('conditionTree') : this.get('condition');

            conditions.forEach(function(condition) {
                states.push(
                    this.get('target_funnel') + (condition.field + condition.relation + (u._.isArray(condition.value) ?
                        condition.value.join() :
                        condition.value)) + retargeting
                );
            }, this);
        }

        return states;
    }
});
