BEM.MODEL.decl({ name: 'vm-feed-timeline', baseModel: 'vm-sync-dm' }, {

    hid: 'id',

    // дата создания записи истории в формате 2015-01-01 01:01:01
    createdAt: 'string',

    // результаты обработки фидов
    parseResults: {
        type: 'model',
        modelName: 'vm-feed-parse-results'
    },

    /**
     * декларация DM модели
     */
    _dmDecl: {
        type: 'object',
        internal: true,
        calculate: function() {
            return {
                name: 'dm-feed-timeline',
                id: this.get('hid')
            };
        }
    }

}, {

    prepareDataFromDM: function(data) {
        return {
            hid: data.hid,
            createdAt: u.moment(data.created_at).format(iget2('vm-feed-timeline', 'dd-mm-yyyy-hh', 'DD.MM.YYYY HH:mm')),
            parseResults: data.parse_results
        };
    }

});
