/**
 * Событие первоначального обновления VM.
 * Триггерится после обновления VM
 * @event sync:init
 */

/**
 * Событие успешной синхронизации в DM.
 * Триггерится после обновления DM
 * @event sync:ok
 * @type {object}
 */

/**
 * Событие успешной синхронизации из DM.
 * Триггерится после обновления VM
 * @event sync:from
 */

/**
 * Событие ошибки при синхронизации в DM.
 * Триггерится при ошибке обновления DM данными VM
 * @event sync:error
 * @type {object}
 */

BEM.MODEL.decl('vm-sync-dm', {
    /**
     * Декларация DM модели
     */
    _dmDecl: {},

    /**
     * Декларация зависимостей модели от других моделей
     * Поле должно иметь тип либо object, либо array
     */
    _deps: {
        type: 'array',
        internal: true
    }

}, {
    /**
     * Находит DM с которым синхронизируется VM
     * Наполняет данными VM
     * @fires sync:init
     */
    init: function() {
        var dm = this.getDM();

        if (typeof dm === 'undefined') {
            throw new Error('model ' + this.name + 'cant find DM ' + JSON.stringify(this.get('_dmDecl')));
        }

        this.syncFromDM();

        this.trigger('sync:init');

        return this;
    },

    /**
     * Находит DM с которым синхронизируется VM
     * @returns {Object} - DM модель
     */
    getDM: function() {
        // инициализация необходимых зависимостей (например, моделей-контейнеров, содержащих искомую модель)
        [].concat(this.get('_deps')).map(function(decl) { BEM.MODEL.getOrCreate(decl); });

        return BEM.MODEL.getOne(this.get('_dmDecl'));
    },

    /**
     * Обновляет DM новыми данными
     * @private
     */
    _setToDM: function() {
        this.getDM().update(this.prepareDataToDM(this.toJSON()));
    },

    /**
     * Получает данные из DM
     * @returns {Object} - обработанные данные из DM
     * @private
     */
    _getFromDM: function() {
        return this.prepareDataFromDM(this.getDM().toJSON());
    },

    /**
     * Подгатавливает данные для обновления DM
     * Обрабатывает данные VM перед одновления DM
     * @returns {Object} - обработанные данные модели
     */
    prepareDataToDM: function(data) {
        return data;
    },

    /**
     * Подгатавливает данные для обновления VM
     * Обрабатывает данные DM перед одновления VM
     * @returns {Object} - обработанные данные модели
     */
    prepareDataFromDM: function(data) {
        return data;
    },

    /**
     * Синхронизирует VM и DM
     * Обновляет DM данными VM
     * @fires sync:ok
     * @fires sync:error
     */
    syncToDM: function() {
        var validationRes = this.validate();

        if (validationRes.valid) {
            this._setToDM();

            this.trigger('sync:ok');
        } else {
            this.trigger('sync:error', validationRes);
        }
    },

    /**
     * Ресет из DM
     * @fires sync:from
     */
    syncFromDM: function() {
        this.update(this._getFromDM());

        this.trigger('sync:from');
    }
});
