/**
 * Событие первоначального обновления VM.
 * Триггерится после обновления VM
 * @event sync:init
 */

/**
 * Событие успешной синхронизации в DM.
 * Триггерится после обновления DM
 * @event sync:ok
 * @type {object}
 */

/**
 * Событие успешной синхронизации из DM.
 * Триггерится после обновления VM
 * @event sync:from
 */

/**
 * Событие ошибки при синхронизации в DM.
 * Триггерится при ошибке обновления DM данными VM
 * @event sync:error
 * @type {object}
 */

BEM.MODEL.decl('vm-sync-dm2', {
    /**
     * Хэш с декларациями DM моделей в виде name: decl
     */
    _dmDecl: {}
}, {
    /**
     * Находит DM с которым синхронизируется VM
     * Наполняет данными VM
     * @fires sync:init
     */
    init: function() {
        var dms = this.getDM();

        Object.keys(dms, function(name) {
            if (typeof dms[name] === 'undefined') {
                throw new Error('model ' + this.name + 'cant find DM ' + JSON.stringify(this.get('_dmDecl')));
            }
        }, this);

        this.syncFromDM();

        this.trigger('sync:init');
    },
    /**
     * Находит DM с которым синхронизируется VM
     * @returns {Object} - хэш с DM моделями
     */
    getDM: function() {
        var decls = this.get('_dmDecl'),
            res = {};

        Object.keys(decls).forEach(function(name) {
            if (decls[name]) {
                res[name] = BEM.MODEL.getOrCreate(decls[name]);
            }
        });

        return res;
    },

    /**
     * Обновляет DM новыми данными
     * @private
     */
    _setToDM: function() {
        var dms = this.getDM();

        Object.keys(dms).forEach(function(name) {
            dms[name].update(this.prepareDataToDM(this.toJSON()));
        });
    },

    /**
     * Получает данные из DM
     * @returns {Object} - обработанные данные из DM
     * @private
     */
    _getFromDM: function() {
        var dms = this.getDM(),
            data = {};

        Object.keys(dms).forEach(function(name) {
            data[name] = dms[name].toJSON();
        });

        return this.prepareDataFromDM(data);
    },

    /**
     * Подгатавливает данные для обновления DM
     * Обрабатывает данные VM перед одновления DM
     * @returns {Object} - обработанные данные модели
     */
    prepareDataToDM: function(data) {
        return data;
    },

    /**
     * Подгатавливает данные для обновления VM
     * Обрабатывает данные DM перед одновления VM
     * @returns {Object} - обработанные данные модели
     */
    prepareDataFromDM: function(data) {
        return data;
    },

    /**
     * Синхронизирует VM и DM
     * Обновляет DM данными VM
     * @fires sync:ok
     * @fires sync:error
     */
    syncToDM: function() {
        var validationRes = this.validate();

        if (validationRes.valid) {
            this._setToDM();

            this.trigger('sync:ok');
        } else {
            this.trigger('sync:error', validationRes);
        }
    },

    /**
     * Ресет из DM
     * @fires sync:from
     */
    syncFromDM: function() {
        this.update(this._getFromDM());

        this.trigger('sync:from');
    }
});
