BEM.MODEL.decl({ model: 'vm-sync-dms', baseModel: 'vm-sync-dm' }, {

    // Хэш с декларациями DM моделей в виде name: decl
    _dmDecl: {}

}, {

    /**
     * Находит DM с которыми синхронизируется VM
     * Наполняет данными VM
     * @fires sync:init
     */
    init: function() {
        var dms = this.getDM();

        Object.keys(dms, function(name) {
            if (typeof dms[name] === 'undefined') {
                throw new Error('model ' + this.name + 'cant find DM ' + JSON.stringify(this.get('_dmDecl')));
            }
        }, this);

        this.syncFromDM();

        this.trigger('sync:init');

        return this;
    },

    /**
     * Находит DM с которым синхронизируется VM
     * @returns {BEM.MODEL[]} - хэш с DM моделями
     */
    getDM: function() {
        var decls = this.get('_dmDecl'),
            res = {};

        Object.keys(this.get('_dmDecl') || []).map(function(name) {
            res[name] = BEM.MODEL.getOrCreate(decls[name]);
        });

        return res;
    },

    /**
     * Обновляет DM-модели новыми данными
     * @private
     */
    _setToDM: function() {
        var dms = this.getDM();

        Object.keys(dms).forEach(function(name) {
            dms[name].update(this.prepareDataToDM(this.toJSON()));
        });
    },

    /**
     * Получает данные из DM-моделей
     * @returns {Object} - обработанные данные из DM
     * @private
     */
    _getFromDM: function() {
        var dms = this.getDM(),
            data = {};

        Object.keys(dms).forEach(function(name) {
            data[name] = dms[name].toJSON();
        });

        return this.prepareDataFromDM(data);
    }

});
