block('wordstat')(

    js()(function() {
        return {
            geoRegion: this.ctx.geoRegion
        };
    }),

    elem('geo-name').tag()('span'),

    elem('humans-count').tag()('span'),

    elem('show-more').content()(function() {

        return {
            block: 'button2',
            mix: {
                block: this.block,
                elem: 'show-more-link'
            },
            mods: {
                size: 's',
                theme: 'normal'
            },
            text: iget2('wordstat', 'show-more', 'Показать еще')
        };
    }),

    elem('suggestion').content()(function() {
        var stat = this.ctx.stat,
            phrase = Object.keys(stat)[0],
            phraseStat = {
                value: u.escapeHTML(phrase),
                stat: stat[phrase]
            },
            geo = this.ctx.geo,
            phrases = this.ctx.phrases;

        return [
            {
                elem: 'info',
                content: [
                    {
                        elem: 'geo',
                        content: iget2('wordstat', 'geo', 'Статистика по региону: {geo}', {
                            geo: {
                                elem: 'geo-name',
                                content: u.getGeoNames(geo)
                            }
                        })
                    },
                    {
                        elem: 'stat',
                        content: phraseStat.stat > 0 ?
                            iget2('wordstat', 'stat-phrase-result-new', '{stat} человек искал «{phrase}» в прошлом месяце', {
                                phrase: phraseStat.value,
                                stat: {
                                    elem: 'humans-count',
                                    content: phraseStat.stat
                                },
                                some: '{stat} человекa искали «{phrase}» в прошлом месяце',
                                many: '{stat} человек искали «{phrase}» в прошлом месяце',
                                count: +phraseStat.stat
                            }) :
                            iget2('wordstat', 'stat-phrase-nobody', 'Никто не искал «{phrase}» в прошлом месяце', {
                                phrase: phraseStat.value
                            })
                    }
                ]
            },
            !!phrases.length && {
                elem: 'similar',
                content: [
                    {
                        elem: 'similar-title',
                        content: [
                            iget2('wordstat', 'similar-phrases-title', 'Похожие запросы')
                        ]
                    },
                    {
                        elem: 'similar-phrases',
                        elemMods: {
                            page: '1'
                        },
                        tag: 'ul',
                        content: phrases.slice(0, 10).map(function(ph) {
                            return {
                                elem: 'similar-phrase',
                                tag: 'li',
                                content: u.escapeHTML(ph)
                            }
                        })
                    },
                    phrases.length > 10 && [
                        {
                            elem: 'similar-phrases',
                            elemMods: {
                                page: '2'
                            },
                            tag: 'ul',
                            content: phrases.slice(10).map(function(ph) {
                                return {
                                    elem: 'similar-phrase',
                                    tag: 'li',
                                    content: u.escapeHTML(ph)
                                }
                            })
                        },
                        {
                            elem: 'show-more'
                        }
                    ]
                ]
            }
        ];
    }),

    elem('input').content()(function() {

        return {
            block: 'input',
            mods: { size: this.ctx.size || 'l' },
            placeholder: iget2('wordstat', 'input-placeholder', 'Товар или услуга'),
            content: {
                elem: 'control'
            }
        }
    }),

    elem('button').content()(function() {

        return {
            block: 'button2',
            mods: {
                size: this.ctx.size || 'promo-l',
                theme: 'normal'
            },
            mix: [
                {
                    block: this.block,
                    elem: 'show-stat-button'
                },
                {
                    block: 'b-metrika',
                    js: {
                        goal: 'SHOW_SPROS',
                        counter: '34'
                    }
                },
                {
                    block: 'b-metrika',
                    js: {
                        goal: 'SHOW_SPROS',
                        counter: '191494'
                    }
                }
            ],
            text: iget2('wordstat', 'button-text', 'Посмотреть статистику')
        };
    }),

    content()(function() {

        return [
            {
                elem: 'title',
                content: iget2('wordstat', 'title', 'Ваш товар ищут')
            },
            {
                elem: 'desc',
                content: iget2('wordstat', 'desc', 'Напишите название своего товара или услуги и узнайте, сколько человек искали его в Яндексе за последний месяц.')
            },
            {
                elem: 'controls',
                content: [
                    {
                        elem: 'input',
                        size: 's'
                    },
                    {
                        elem: 'button',
                        size: 's'
                    }
                ]
            },
            {
                elem: 'result'
            }
        ];
    })
);
