BEM.DOM.decl({ block: 'wordstat' }, {

    onSetMod: {
        loading: {
            yes: function() {
                this.blockInside('button2')
                    .setMod('theme', 'action')
                    .setMod('progress', 'yes');
            },
            '': function() {
                this.blockInside('button2')
                    .delMod('progress')
                    .setMod('theme', 'normal');
            }
        },
        // помимо выставления loading_yes еще применяются css стили
        updating: {
            yes: function() {
                this.setMod('loading', 'yes');
            },
            '': function() {
                this.delMod('loading');
            }
        },
        result: {
            yes: function() {
                this.elem('desc').slideUp();
                this.elem('result').slideDown();
            },
            '': function() {
                this.elem('result').slideUp();
            }
        }
    },

    /**
     * Инстанс блока i-request_type_ajax
     */
    _request: null,

    /**
     * Получаем инстанс блока i-request_type_ajax для создания запросов
     * @returns {null|BEM}
     * @private
     */
    _getRequest: function() {
        return this._request || (this._request = BEM.create('i-request_type_ajax', {
            type: 'post',
            url: '/public',
            dataType: 'json',
            callbackCtx: this
        }));
    },

    /**
     * Получение статистики по фразе
     * @private
     */
    _getSuggestion: function() {
        this.hasMod('result') ?
            this._loadSuggestion('updating', 'yes') :
            this._loadSuggestion('loading', 'yes');
    },

    /**
     * Обновление статистики по фразе
     * @private
     */
    _loadSuggestion: function(status) {
        var phrase = this.blockInside('input', 'input').val();

        if (this._isFieldValid(phrase)) {

            this.setMod(status, 'yes');

            this._requestSuggestion(phrase)
                .then(function(response) {
                    this._showResult(response);
                    this.delMod(status);
                }.bind(this))
                .catch(function(response) {
                    this.delMod(status);
                    this._showError(response);
                }.bind(this));
        }
    },

    /**
     * Проверка значения в поле на валидность
     * @param {String} phrase
     * @return {boolean}
     * @private
     */
    _isFieldValid: function(phrase) {
        return phrase.length !== 0;
    },

    /**
     * Загрузка статистики по фразе
     * @param {String} phrase - фраза
     * @private
     */
    _requestSuggestion: function(phrase) {
        var geo = this.params.geoRegion;

        return new Promise(function(resolve, reject) {

            this._getRequest().get(
                {
                    srcPhrases: phrase,
                    cmd: 'ajaxGetSuggestion',
                    promo: 'spros',
                    get_stat: 1,
                    geo: geo
                },
                function(response) {
                    resolve(response);
                },
                function(response) {
                    reject(response);
                }
            );

        }.bind(this));
    },

    /**
     * Отображает результат
     * @param {Object} response
     * @private
     */
    _showResult: function(response) {

        BEM.DOM.update(this.elem('result'), BEMHTML.apply({
            block: 'wordstat',
            elem: 'suggestion',
            stat: response.stat,
            phrases: response.phrases,
            geo: this.params.geoRegion
        }));

        this.setMod('result', 'yes');
    },

    /**
     * Отображает ошибку
     * @private
     */
    _showError: function() {
        BEM.blocks['b-user-dialog'].alert({
            message: iget2(
                'wordstat',
                'server-error-message',
                'Статистика временно не доступна.'
            )
        });
    },

    /**
     * Обработчик нажатия на кнопку "Показать статистику"
     * @private
     */
    _onButtonClick: function() {
        this._getSuggestion();
    },

    /**
     * Обработчик нажатия на похожую фразу
     * @param {Event} e
     * @private
     */
    _onPhraseClick: function(e) {
        this.blockInside('input', 'input').val($(e.target).text());
        this._getSuggestion();
    },

    /**
     * Обработчик нажатий клавиш в инпуте
     * @param {Event} e
     * @private
     */
    _handleKeypress: function(e) {
        if (e.which === BEM.blocks.keycodes.ENTER) {
            this._getSuggestion();
        }
    },

    /**
     * Обработчик фокуса на инпуте
     * @private
     */
    _onInputFocus: function() {
        // будет переопределен
    },

    /**
     * Обработчик нажатия на "Показать еще"
     * @private
     */
    _onShowMoreClick: function() {
        this.toggleMod(this.elem('result'), 'page', '2');
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('focus', 'input', function(e) {
            this._onInputFocus(e);
        }).liveBindTo('show-stat-button', 'click', function(e) {
            this._onButtonClick(e);
        }).liveBindTo('input', 'keypress', function(e) {
            this._handleKeypress(e);
        }).liveBindTo('similar-phrase', 'click', function(e) {
            this._onPhraseClick(e);
        }).liveBindTo('show-more-link', 'click', function(e) {
            this._onShowMoreClick(e);
        });
    }

});
