(function() {
    if (u.consts('is_beta')) {
        var modelSet = BEM.MODEL.prototype.set,
            timeLoggerParams = window.iTimeLogger.params,
            scriptExtRegex = /\.js$/,
            logUrl = '/log-js/model-errors/' + (timeLoggerParams.cmd || 'index') + '/' + timeLoggerParams.reqid,
            errors = [],
            // отсылаем ошибки пачками
            sendErrors = $.debounce(function() {
                BEM.create('i-request_type_ajax', {
                    url: logUrl,
                    type: 'POST',
                    dataType: 'json',
                    cache: false
                }).get(JSON.stringify(errors), $.noop);
                errors.length = 0;
            }, 1000),

            addError = function(newError) {
                var queuedError = u._.find(errors, function(error) {
                    return u._.isEqual(error, newError);
                });

                // дважды одну и туже ошибку в пачке не шлем
                if (!queuedError) {
                    errors.push(newError);
                    sendErrors();
                }
            };

        BEM.MODEL.prototype.set = function(name, value, opts) {
            if (!this.fieldsDecl[name]) {
                try {
                    throw new Error();
                } catch (err) {
                    var stackTrace = BEM.blocks['i-stack-trace'].fromError(err),
                        modelName = this.name;

                    stackTrace.traceSourceCode({
                        linesBefore: 1,
                        linesAfter: 1,
                        // отфильтровываем вызовы внутри jquery и код который не имеет отношения внешним скриптам
                        filterScript: function(scriptPath) {
                            return scriptPath.indexOf('jquery') === -1 && scriptExtRegex.test(scriptPath);
                        }
                    })
                        .then(function(sourceStackTrace) {
                            addError({
                                model: modelName,
                                field: name,
                                // удаляем первый элемент стектрейса, потому как он ведет на строку,
                                // где создавалась ошибка
                                // общее число элементов ограничиваем 10, т.к. FF генерирует слишком большой стектрейс
                                stacktrace: sourceStackTrace.slice(1, 11)
                            });
                        });
                }
            }

            return modelSet.apply(this, arguments);
        };
    }
})();
