module.exports = {
    levels: ['source.blocks'],
    profiles: {
        // тесты
        'test-bundles': {
            handler: './walker-plugins/test-bundler',
            handlerConfig: {
                resultPath: 'bundles.json',
                baseBundlePath: 'test.bundles',
                devEntities: ['dev-page', 'dev-page_type_test'],
                defaultBundleConfig: {
                    target: '?.test-result.json',
                    coverage: true,
                    baseLevels: ['node_modules/direct-dev/blocks', 'test.blocks']
                }
            }
        },
        'test-report-console': {
            handler: './walker-plugins/test-reporter',
            handlerConfig: { reporter: 'console' },
            levels: ['test.bundles']
        },
        'coverage-report-console': {
            handler: './walker-plugins/coverage-reporter',
            handlerConfig: { reporter: 'console' },
            levels: ['test.bundles']
        },

        'test-report-teamcity': {
            handler: './walker-plugins/test-reporter',
            handlerConfig: { reporter: 'teamcity' },
            levels: ['test.bundles']
        },
        'coverage-report-teamcity': {
            handler: './walker-plugins/coverage-reporter',
            handlerConfig: { reporter: 'teamcity' },
            levels: ['test.bundles']
        },

        'coverage-report-html': {
            handler: './walker-plugins/coverage-reporter',
            handlerConfig: { reporter: 'html' },
            levels: ['test.bundles']
        },

        'sandbox-bundles': {
            handler: './walker-plugins/test-bundler',
            handlerConfig: {
                resultPath: 'bundles.json',
                baseBundlePath: 'sandbox.bundles',
                devEntities: ['dev-page', 'dev-page_type_sandbox', 'dev-page_type_test'],
                defaultBundleConfig: {
                    coverage: false,
                    baseLevels: ['node_modules/direct-dev/blocks', 'test.blocks']
                }
            }
        }
    }
};
