BEM.DOM.decl({ block: 'b-checkboxes-group', modName: 'ignored', modVal: 'yes' }, {
    onSetMod: {
        js: function() {
            this._ignoredMap = this.params && this.params.ignored || {};

            this.__base.apply(this, arguments);

            // перестраиваем группу (даёт возможность сменить статус общего чекбокса в зависимости от состояния группы)
            this.rearrange();
        }
    },

    /**
     * @private
     * @type {Object}
     */
    _ignoredMap: null,

    /**
     * Обработчик клика по общему чекбоксу
     * @private
     * @param {jQuery.Event} e
     */
    _onClickMainCheckbox: function(e) {
        var checked = e.block.isChecked(),
            modName = checked ? 'yes' : '';

        this._getCheckboxes().forEach(function(checkbox, index) {
            this._ignoredMap[index] || checkbox.setMod('checked', modName);
        }, this);

        this
            ._correctCheckedMap({ checked: checked })
            ._notify();
    },


    /**
     * По необходимости меняет статус общего чекбокса
     * @private
     * @returns {BEM}
     */
    _checkStatusMain: function() {
        var count = {
            all: this._count.all - Object.keys(this._ignoredMap).length,
            checked: this._count.checked
        };

        this._getMainCheckbox()
            .setMod('checked', count.all && count.checked == count.all ? 'yes' : '')
            // главнй чекбокс бессмыслен без группы
            .setMod('disabled', !count.all ? 'yes' : '');

        return this;
    },

    /**
     * Возвращает выбранные чекбоксы (без общего)
     * @returns {BEM[]}
     */
    getChecked: function() {
        return this
            ._getCheckboxes()
            .filter(function(item, index) {
                return !this._ignoredMap[index] && item.isChecked();
            }, this);
    },

    /**
     * Корректирует массив с выбранными чекбоксами, проверяет конкретный чекбокс
     * @param {Number} index
     * @param {Boolean} [checked]
     */
    _correctOneOfCheckedMap: function(index, checked) {
        checked == undefined && (checked = this._getCheckboxes()[index].isChecked());

        checked && !this._ignoredMap[index] ?
            this._checkedMap[index] = checked :
            delete this._checkedMap[index];
    },

    /**
     * Задает индексы игнорируемых чекбоксов
     * @param {Object} checkboxes
     */
    setIgnored: function(checkboxes) {
        this._ignoredMap = checkboxes;

        this
            ._correctCheckedMap()
            ._checkStatusMain()
            ._notify();
    }
});
