BEM.DOM.decl('b-checkboxes-group', {

    onSetMod: {

        js: function() {
            this._checkedMap || (this._checkedMap = {});

            this._count || (this._count = {
                all: this._getCheckboxes().length,
                checked: 0
            });
        }

    },

    /**
     * @private
     * @type {Object}
     */
    _count: null,

    /**
     * Обработчик клика по общему чекбоксу
     * @private
     * @param {jQuery.Event} e
     */
    _onClickMainCheckbox: function(e) {
        var checked = e.block.isChecked(),
            modName = checked ? 'yes' : '';

        this._getCheckboxes().forEach(function(checkbox) {
            !checkbox.isDisabled() && checkbox.setMod('checked', modName);
        }, this);

        this
            ._correctCheckedMap({ checked: checked })
            ._notify();
    },

    /**
     * Обработчик клика по не общему чекбоксу
     * @private
     * @param {jQuery.Event} e
     * @param {Number} index индекс чекбокса
     */
    _onClickCheckbox: function(e, index) {
        this
            ._correctCheckedMap({
                checked: e.block.isChecked(),
                index: index
            })
            ._checkStatusMain()
            ._notify();
    },

    /**
     * По необходимости меняет статус общего чекбокса
     * @private
     * @returns {BEM}
     */
    _checkStatusMain: function() {
        var count = this._count,
            countDisabledCheckboxes = this._getDisabledCheckboxes().length,
            isAllChecked;

        if (count.all) {
            isAllChecked = count.checked === count.all || count.checked === count.all - countDisabledCheckboxes;
        }

        this._getMainCheckbox().setMod('checked', isAllChecked ? 'yes' : '');

        return this;
    },

    /**
     * @private
     * @type {Object}
     */
    _checkedMap: null,

    /**
     * Корректирует объект с состояниями чекбоксов, проверяет всю группу, либо конкретный чекбокс
     * @param {Object} [obj]
     *  @param {Number} [obj.index]
     *  @param {Number} [obj.checked]
     * @returns {BEM}
     */
    _correctCheckedMap: function(obj) {
        var count = this._count;

        obj || (obj = {});

        if (obj.index == undefined) {
            this._checkedMap = {};

            for (var i = 0, size = count.all; i < size; i++) {
                this._correctOneOfCheckedMap(i, obj.checked);
            }
        } else {
            this._correctOneOfCheckedMap(obj.index, obj.checked);
        }

        count.checked = Object.keys(this._checkedMap).length;

        return this;
    },

    /**
     * Корректирует массив с выбранными чекбоксами, проверяет конкретный чекбокс
     * @param {Number} index
     * @param {Boolean} [checked]
     */
    _correctOneOfCheckedMap: function(index, checked) {
        var checkbox = this._getCheckboxes()[index];

        checked === undefined && (checked = checkbox.isChecked());

        // При выборе главного чекбокса checked = true для всех чекбоксов
        // нужно фильтровать неактивные чекбоксы
        // иначе this._checkedMap не совпадает с DOM
        if (checkbox.isDisabled()) {
            checked = false;
        }

        checked ?
            this._checkedMap[index] = checked :
            delete this._checkedMap[index];
    },

    /**
     * Нотификация изменений
     * @returns {BEM}
     */
    _notify: function() {
        var allCheckboxes = this._getCheckboxes(),
            checkedIndexes = Object.keys(this._checkedMap),
            checkedItems = checkedIndexes.map(function(index) {
                return allCheckboxes[index];
            });

        return this.trigger('change', {
            indexes: checkedIndexes,
            checkboxes: checkedItems
        });
    },

    /**
     * @private
     * @type {BEM[]}
     */
    _allCheckboxes: null,

    /**
     * Возвращает все чекбоксы
     * @returns {BEM[]}
     */
    _getAllCheckboxes: function() {
        return this._allCheckboxes || (this._allCheckboxes = this.findBlocksOn('item', 'checkbox'));
    },

    /**
     * @private
     * @type {BEM}
     */
    _mainCheckbox: null,

    /**
     * Возвращает общий чекбокс
     * @returns {BEM}
     */
    _getMainCheckbox: function() {
        return this._mainCheckbox || (this._mainCheckbox = this._getAllCheckboxes()[0]);
    },

    /**
     * @private
     * @type {BEM[]}
     */
    _checkboxes: null,

    /**
     * Возвращает все не общие чекбоксы
     * @returns {BEM[]}
     */
    _getCheckboxes: function() {
        return this._checkboxes || (this._checkboxes = this._getAllCheckboxes().slice(1));
    },

    /**
     * Возвращает неактивные чекбоксы (без общего)
     * @returns {BEM[]}
     */
    _getDisabledCheckboxes: function() {
        return this
            ._getCheckboxes()
            .filter(function(item) {
                return item.isDisabled();
            });
    },

    /**
     * Возвращает выбранные чекбоксы (без общего)
     * @returns {BEM[]}
     */
    getChecked: function() {
        return this
            ._getCheckboxes()
            .filter(function(item) {
                return item.isChecked();
            });
    },

    /**
     * Сбрасывает закэшированные чекбоксы
     */
    dropCachedItems: function() {
        this.dropElemCache('item');

        this._mainCheckbox = this._checkboxes = this._allCheckboxes = null;

        this._count.all = this._getCheckboxes().length;
    },

    /**
     * Сбрасывает у всех чекбоксов checked
     * @return {BEM.DOM}
     */
    unCheckAll: function() {
        this._onClickMainCheckbox({
            block: this._getMainCheckbox().delMod('checked')
        });

        return this;
    },

    /**
     * Возвращает все чекбоксы кроме общего
     * @returns {BEM[]}
     */
    getCheckboxes: function() {
        return this._getCheckboxes();
    },

    /**
     * Перестраивает группу кнопок (даёт возможность перерисовки чекбоксов)
     */
    rearrange: function() {
        this.dropCachedItems();

        this._correctCheckedMap();

        this._checkStatusMain();

        return this;
    },

    /**
     * Геттер для _checkedMap
     * @returns {Object}
     */
    getCheckedMap: function() {
        return this._checkedMap;
    }

}, {

    _onCheckClick: function(e) {
        var index,
            domElem = e.block.domElem;

        index = domElem.data('checksGroupIndex') ||
            domElem.data('checksGroupIndex', index = this.elem('item').index(domElem)) && index;

        index == -1 || (index ?
            this._onClickCheckbox(e, index - 1) : // index - 1 потому что главный не считаем
            this._onClickMainCheckbox(e));
    },

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'checkbox', this._onCheckClick);
    }

});
