BEM.DOM.decl({
    block: 'b-chooser',
    elem: 'action'
}, {

    /**
     * Обработчик события «клик»
     * @private
     */
    _onClick: function() {/* Переопределяется в модификаторах элемента */},

    /**
     * Кэширует item
     * @returns {BEM}
     * @private
     */
    _getItem: function() {
        return this._item || (this._item = this.elemInstance(this.closestElem('item')));
    },

    /**
     * Возвращает экземпляр кнопки
     * @returns {BEM}
     * @private
     */
    _getButton: function() {
        return this._button || (this._button = this.findBlockOn('button'));
    },

    /**
     * Делает кнопку неактивной
     * @returns {BEM}
     */
    disable: function() {
        this._getButton().setMod('disabled', 'yes');

        return this;
    },

    /**
     * Делает кнопку активной
     * @returns {BEM}
     */
    enable: function() {
        this._getButton().delMod('disabled');

        return this;
    },

    /**
     * Обработчик ошибки
     * @private
     */
    _onError: function() {/* Переопределяется в модификаторах элемента */}

}, {

    live: function() {

        this
            .liveBindTo('click', function(e) {
                this._onClick(e);
            })
            .liveInitOnParentEvent('error', function(e, data) {
                this._onError(e, data);
            });

    }

});

BEM.DOM.decl({
    block: 'b-chooser',
    elem: 'action',
    modName: 'type',
    modVal: 'remove'
}, {

    /**
     * Триггерит событие removing
     * @param {Event} e
     * @override
     * @private
     */
    _onClick: function(e) {
        this.disable()
            .trigger('removing', this._getItem().getItemParams());

        e.stopPropagation();
    },

    /**
     * Обработчик ошибки
     * @param {Event} e
     * @param {Object} error
     * @returns {BEM}
     * @private
     */
    _onError: function(e, error) {
        error.type == 'remove' && this.enable();

        return this;
    }

}, {

});

BEM.DOM.decl({
    block: 'b-chooser',
    elem: 'action',
    modName: 'type',
    modVal: 'remove-confirm'
}, {

    /**
     * Обработчик события «клик» вне элемента confirm-remove
     * @param {Event} e
     * @private
     */
    _onOuterClick: function(e) {
        var isOutsideClick = $(e.target).closest(this.domElem).length,
            isRemoveButtonClick = $(e.target).closest(this._getItem().elem('action', 'type', 'remove')).length;

        if (!isOutsideClick && !isRemoveButtonClick) {
            this._getItem().toggleState('confirm-remove');
            this.unbindFromDoc('click');
        }
    },

    /**
     * Переходим в режим ожидания подтверждения и подписываемся на «клик» вне элемента
     * @param {Event} e
     * @override
     * @private
     */
    _onClick: function(e) {
        this.bindToDoc('click', this._onOuterClick);
        this._getItem().toggleState('show-confirm');

        e.stopPropagation();
    }

}, {

});
