BEM.DOM.decl({
    block: 'b-chooser',
    elem: 'group'
}, {

    onSetMod: {

        js: function() {
            // ищем группу в которую вложена текущая группа
            var parentGroup = this.domElem.parent().parent(this.buildSelector('group'));

            if (parentGroup.length) {
                this._parentGroup = this.elemInstance(parentGroup);
            }

            this._groupTitle = this.elemInstance(this.domElem.children());
        }

    },

    /**
     * Кэшированная группа над этой группой
     */
    _parentGroup: null,

    /**
     * Хранит результаты поиска по элементам item для текущей группы
     */
    _searchStatus: null,

    /**
     * Очищает структуру this._searchStatus для нового поиска
     * @private
     */
    _search: function() {
        this._searchStatus = {
            'group-title': null,
            items: {
                instances: [],
                findCount: 0
            }
        };
    },

    /**
     * Количество скрытых от поиска элементов item
     */
    _disabledItems: 0,

    /**
     * Скрывает группу от поиска
     * @returns {BEM}
     */
    disable: function() {
        if (++this._disabledItems == this.params.childrenCount) {
            this.setMod('disabled', 'yes');
            this._groupTitle.setMod('disabled', 'yes');
        }

        return this;
    },

    /**
     * Открывает группу для поиска
     * @returns {BEM}
     */
    enable: function() {
        if (--this._disabledItems != this.params.childrenCount) {
            this.delMod('disabled');
            this._groupTitle.delMod('disabled');
        }

        return this;
    },

    /**
     * Заполняет this._searchStatus
     * @param {String} name - имя item'a
     * @param {Boolean|String} isFind - флаг, найдено/не найдено
     * @param {BEM} [instance] - экземпляр item'a
     * @param {Boolean} isReset - флаг, очистки результатов поиска
     * @returns {BEM}
     */
    updateSearchStatus: function(name, isFind, instance, isReset) {
        if (name == 'group-title') {
            this._searchStatus['group-title'] = {
                isFind: isFind,
                verified: true
            };
        } else {
            this._searchStatus.items.instances.push({
                instance: instance,
                isFind: isFind
            });

            isFind && this._searchStatus.items.findCount++;
        }

        return this._checkSearchStatus(isReset);
    },

    /**
     * Проверяет this._searchStatus, все элементы item текущей группы должны отдать результат поиска
     * @param {Boolean} isReset - флаг, очистки результатов поиска
     * @returns {BEM}
     * @private
     */
    _checkSearchStatus: function(isReset) {
        var items = this._searchStatus.items,
            groupTitle = this._searchStatus['group-title'];

        // если проверены все элементы item и заголовок текущей группы
        if (items.instances.length == this.params.childrenCount && groupTitle.verified) {
            this._updateSelfStatus(items.findCount || groupTitle.isFind, isReset)
                ._updateItemsStatus(items.findCount, groupTitle.isFind, isReset);
        }

        return this;
    },

    /**
     * Передает результат поиска группе выше(если она есть)
     * @param {Boolean} isFind - флаг, найдено/не найдено
     * @param {Boolean} isReset - флаг, очистки результатов поиска
     * @returns {BEM}
     */
    _updateSelfStatus: function(isFind, isReset) {
        if (this._parentGroup) {
            isFind || this.toggleGroup(false);

            // группа выше
            this._parentGroup.updateSearchStatus('group', isFind, this, isReset);
        } else {
            // родительский блок, необходимо для отслеживания конца поиска
            this.getParent()._verifyItemsCount(isFind);
        }

        return this;
    },

    /**
     * По результатам поиска выставляет состояние текущей группе и её элементам item
     * Варианты:
     *  1) найдено в isFindOnTitle и isFindOnItems - раскрываем группу и показываем все её элементы item
     *  2) найдено только isFindOnTitle - раскрываем группу и показываем все её элементы item
     *  3) найдено только isFindOnItems - раскрываем группу но оставляем только те элементы item в которых нашли значение
     *  4) нигде не нашли - скрываем группу
     * @param {Boolean} isFindOnItems - true значит есть совпадения в элементе item
     * @param {Boolean} isFindOnTitle - true значит есть совпадения в item group-title
     * @param {Boolean} isReset - флаг, очистки результатов поиска
     * @returns {BEM}
     * @private
     */
    _updateItemsStatus: function(isFindOnItems, isFindOnTitle, isReset) {
        if (isFindOnItems || isFindOnTitle) {
            this.toggleGroup(!isReset)
                .show();

            this._searchStatus.items.instances.forEach(function(item) {
                isFindOnTitle || item.isFind ?
                    item.instance.show() :
                    item.instance.hide();
            });
        } else {
            this.hide();
        }

        return this;
    },

    val: function() {
        return {
            hidden: this.hasMod('hidden', 'yes') || this.hasMod('visibility', 'hidden'),
            name: this.params.name
        };
    },

    getGroupParams: function(extraParams) {
        var params = $.extend({}, this.params);

        delete params.uniqId;

        params.hidden = this.hasMod('hidden', 'yes') || this.hasMod('visibility', 'hidden');

        return $.extend({ extraParams: extraParams || {} }, params);
    },

    /**
     * Сворачивает/разворачивает группу
     * @param {Boolean} [condition] - условие
     * @returns {BEM}
     */
    toggleGroup: function(condition) {
        ['group-list', 'item'].forEach(function(name) {
            this.elemInstance(name).toggleMod('open', 'yes', condition);
        }, this);

        return this;
    },

    /**
     * Показывает группу
     * @returns {BEM}
     */
    show: function() {
        return this.delMod('visibility');
    },

    /**
     * Скрывает группу
     * @returns {BEM}
     */
    hide: function() {
        return this.setMod('visibility', 'hidden');
    }

}, {

});
