BEM.DOM.decl({
    block: 'b-chooser',
    elem: 'item',
    modName: 'type',
    modVal: 'group-title'
}, {

    /**
     * Клик по элементу. Сворачиваем/разворачиваем группу
     * @override
     * @private
     */
    _onClick: function() {
        this._group.toggleGroup();
    },

    /**
     * Обрабатывает успешный поиск. Подсвечиваем совпадение
     * @param {Object} data
     * @returns {BEM}
     * @override
     * @private
     */
    _onFind: function(data) {
        return this._highlight(data);
    },

    /**
     * Обрабатывает неуспешный поиск. Восстанавливаем текст
     * @returns {BEM}
     * @override
     * @private
     */
    _onMissed: function() {
        var searchParams = this.params.search;

        if (searchParams) {
            u._.keys(searchParams).forEach(function(key) {
                this.setContent(searchParams[key], this.elem(key));
            }, this);

            return this;
        } else {
            return this.setContent(this.params.text);
        }
    }

}, {

});
