BEM.DOM.decl({
    block: 'b-chooser',
    elem: 'item'
}, {

    onSetMod: {

        js: function() {
            var group = this.closestElem('group');

            if (group.length) {
                this._group = this.elemInstance(group);
            }
        }

    },

    /**
     * Закэшированная группа
     */
    _group: null,

    /**
     * Формирует параметры текущего элемента
     * @param {Object} [extraParams] - дополнительные параметры
     * @returns {{
     *  name: String,
     *  selected: Boolean,
     *  extraParams: *
     * }}
     */
    getItemParams: function(extraParams) {
        var params = $.extend({}, this.params);

        delete params.uniqId;

        params.selected = this.hasMod('selected', 'yes');
        params.disabled = this.hasMod('disabled', 'yes');
        params.hidden = this.hasMod('hidden', 'yes') || this.hasMod('visibility', 'hidden');
        params.indeterminate = this.hasMod('indeterminate', 'yes');

        return $.extend({ extraParams: extraParams || {} }, params);
    },

    val: function() {
        return {
            selected: this.hasMod('selected', 'yes'),
            disabled: this.hasMod('disabled', 'yes'),
            hidden: this.hasMod('disabled', 'yes'),
            name: this.params.originalName
        };
    },

    /**
     * Меняет состояние выбран/не выбран у текущего элемента
     * @param {*} triggerParams - дополнительные параметры
     * @returns {BEM}
     */
    toggle: function(triggerParams) {
        this.toggleMod('selected', 'yes');

        this.trigger('change', this.getItemParams(triggerParams));

        return this;
    },

    /**
     * Определяет наличие модификатора _multi_yes
     * @returns {Boolean}
     * @private
     */
    _isMulti: function() {
        return this.getParent().hasMod('multi') || this.getParent().hasMod('virtual');
    },

    /**
     * Определяет наличие модификатора _allow-empty_yes
     * @returns {Boolean}
     * @private
     */
    _isAllowEmpty: function() {
        return this.getParent().hasMod('allow-empty', 'yes');
    },

    /**
     * Клик по элементу
     * @returns {BEM}
     * @private
     */
    _onClick: function() {
        this.trigger('select-item', this.getItemParams());

        if (this.hasMod('indeterminate', 'yes')) {
            this.delMod('indeterminate');
            this.trigger('change', this.getItemParams());

            return this;
        }

        if (!this._isMulti() && !this._isAllowEmpty() && this.hasMod('selected', 'yes')) {
            return this;
        } else {
            return this.toggle();
        }
    },

    /**
     * Находит query в тексте элемента и подсвечивает его
     * @param {Object} data
     *  @param {String} data.query - строка запроса
     *  @param {RegExp} data.regexp - RegExp из строки запроса
     * @returns {BEM}
     * @private
     */
    _highlight: function(data) {
        var searchParams = this.params.search;

        if (searchParams) {
            u._.keys(searchParams).forEach(function(key) {
                var text = searchParams[key].toString(),
                    matches = [], mat, res, sub, stack = [], cursor, i;

                if (data.query) {
                    while (res = data.regexp.exec(text)) {
                        matches.push(res);
                    }

                    if (matches.length) {
                        cursor = 0;
                        for (i = 0; i < matches.length; i++) {
                            mat = matches[i];

                            // простая часть строки
                            sub = text.substring(cursor, mat.index);
                            sub && stack.push(u.escapeHTML(sub));

                            // "найденная" часть строки
                            stack.push(BEMHTML.apply({
                                block: 'b-chooser',
                                elem: 'hlted',
                                content: u.escapeHTML(mat[0])
                            }));

                            cursor = mat.index + mat[0].length;
                        }
                        sub = text.substring(cursor);
                        sub && stack.push(u.escapeHTML(sub));
                        text = stack.join('');
                    } else {
                        text = u.escapeHTML(text);
                    }
                }

                this.setContent(text, this.elem(key));
            }, this);

            return this;
        } else {
            return this.setContent(data.query ?
                this.params.text.toString().replace(data.regexp, function(str) {
                    return BEMHTML.apply({
                        block: 'b-chooser',
                        elem: 'hlted',
                        content: u.escapeHTML(str)
                    });
                }) :
                this.params.text);
        }
    },

    /**
     * Устанавливает новый html-контент
     * @param {*} content - контент. Что бы не было XSS, контент должен быть экранирован.
     * Здесь экранировать незя, поскольку есть шаблонизированные строки с "желательными" тегами вида:
     *
     * простой_текст<tag>текст или </tag>простой_текст
     *
     * @param {*} elem - элемент
     * @returns {BEM}
     */
    setContent: function(content, elem) {
        if (elem === undefined) {
            //получаем элемент text
            elem = this.elem('text');
        }

        elem.html() != content && elem.html(content);

        return this;
    },

    /**
     * Обрабатывает успешный поиск
     * @param {Object} data
     *  @param {String} data.query - строка запроса
     *  @param {RegExp} data.regexp - RegExp из строки запроса
     * @returns {BEM}
     * @private
     */
    _onFind: function(data) {
        // если item не состоит в группе - показываем его
        // для элементов в группе состояние определяет группа
        this._group || this.show();

        return this._highlight(data);
    },

    /**
     * Обрабатывает неуспешный поиск
     * @returns {BEM}
     * @private
     */
    _onMissed: function() {
        // элементы состоящие в группе и на которой ничего не нашлось, все равно могут показываться пользователю
        // если item состоит в группе мы устанавливаем ему дефолтный текст
        // элементы не состоящие в группе мы можем уверенно скрывать
        var searchParams = this.params.search;

        if (searchParams && this._group) {
            u._.keys(searchParams).forEach(function(key) {
                this.setContent(searchParams[key], this.elem(key));
            }, this);

            return this;
        } else if (!searchParams && this._group) {
            return this.setContent(this.params.text);
        } else {
            return this.hide();
        }
    },

    /**
     * Сбрасывает item в начальное состояние
     * @private
     */
    _reset: function() {
        var searchParams = this.params.search,
            elem,
            content;

        if (searchParams) {
            u._.keys(searchParams).forEach(function(key) {
                elem = this.elem(key);
                content = searchParams[key];

                elem.html() !== content && elem.text(content);
            }, this);
        } else {
            elem = this.elem('text');
            content = this.params.text;

            elem.html() !== content && elem.text(content);
        }

        this._updateGroupSearchStatus(true, true);
    },

    /**
     * Поиск на текущем элементе
     * @param {Object} data
     *  @param {String} data.query - строка запроса
     *  @param {RegExp} data.regexp - RegExp из строки запроса
     * @private
     */
    _search: function(data) {
        var isFind = false,
            searchParams = this.params.search,
            regexp = new RegExp(data.query, 'ig');
            regexpFullMatch = new RegExp('^' + data.query + '$', 'ig');

        if (this._isActive()) {
            if (searchParams) {
                u._.keys(searchParams)
                    .forEach(function(key) {
                        isFind || (isFind = regexp.test(searchParams[key]));
                    });
            } else {
                isFind = regexp.test(this.params.text) || regexpFullMatch.test(this.params.id);
            }
        }

        if (isFind) {
            this._onFind(data);
        } else {
            this._onMissed(data);
        }

        this._updateGroupSearchStatus(isFind);
    },

    /**
     * Передает результат поиска группе(если она есть)
     * @param {Boolean} isFind - флаг, найдено/не найдено
     * @param {Boolean} isReset - флаг, очистки результатов поиска
     * @private
     */
    _updateGroupSearchStatus: function(isFind, isReset) {
        if (this._group) {
            this._group.updateSearchStatus(this.getMod('type') || 'item', isFind, this, isReset);
        } else {
            isReset && this.show();
            this.getParent()._verifyItemsCount(isFind);
        }
    },

    /**
     * Меняет модификатор state
     * @param {String} modVal - новое значение state
     * @returns {BEM}
     */
    toggleState: function(modVal) {
        return this.hasMod('state', modVal) ?
            this.delMod('state') :
            this.setMod('state', modVal);
    },

    /**
     * Показывает item
     * @returns {BEM}
     */
    show: function() {
        return this.delMod('visibility');
    },

    /**
     * Скрывает item
     * @returns {BEM}
     */
    hide: function() {
        return this.setMod('visibility', 'hidden');
    },

    /**
     * Скрывает item от поиска
     * @returns {BEM}
     */
    disable: function() {
        !this.hasMod('disabled') && this._group && this._group.disable();

        return this.setMod('disabled', 'yes');
    },

    /**
     * Открывает item для поиска
     * @returns {BEM}
     */
    enable: function() {
        this.hasMod('disabled', 'yes') && this._group && this._group.enable();

        return this.delMod('disabled');
    },

    /**
     * Удаляет item из DOM-дерева
     * @param {Object} triggerParams - дополнительные параметры
     */
    remove: function(triggerParams) {
        this.elemInstances('action').forEach(function(instance) {
            instance.destruct();
        });

        this.trigger('remove', this.getItemParams(triggerParams));

        this.destruct();
    },

    /**
     * item можно выбрать/подсветить
     * @returns {Boolean}
     * @private
     */
    _isActive: function() {
        return !(this.hasMod('disabled') || this.hasMod('type', 'separator'));
    }

}, {

    live: function() {

        this.liveBindTo('click', function(e, data) {
            !this._isActive() || this._onClick();
        });

        this.liveBindTo('pointerover', function() {
            !this._isActive() || this.getParent().hoverItem(this.params.name);
        });
        this.liveBindTo('pointerout', function() {
            !this._isActive() || this.getParent().unHoverItem(this.params.name);
        });

    }

});
