BEM.DOM.decl({ block: 'b-chooser', modName: 'multi', modVal: 'yes' }, {

    onSetMod: {
        js: function() {
            this.__base();

            this._groupCheckbox = this.findBlockInside('select-all', 'checkbox');
        }
    },

    /**
     * Сбрасывает все выбранные значения
     */
    uncheckAll: function() {
        this._notToggleAll = false;

        if (this._groupCheckbox && this._groupCheckbox.getMod('checked') === 'yes') {
            this._groupCheckbox.setMod('checked', '')
        } else {
            this._toggleAll(false);
        }
    },

    /**
     * В зависимости от data.selected добавляет/удаляет item в хранилище
     * @param {Object} data
     *  @param {String} data.name - имя элемента
     *  @param {Boolean} data.selected - выбран/не выбран
     *  @param {*} [data.extraParams] - дополнительные параметры
     * @returns {BEM}
     * @override
     * @private
     */
    _onItemChange: function(data) {
        if (!this._fromGroupCheckbox) {
            this.trigger('change', data);
            this._groupCheckbox && this._checkGroupCheckbox(this.getAll());
        }

        return this;
    },

    /**
     * Возвращает выбранные элементы
     * @returns {Array}
     * @override
     */
    getSelected: function() {
        return this.getAll('selected');
    },

    _groupTimer: null,

    /**
     * Выставляет правильный модификатор checked главному checkbox
     * @param {Array} items - все элементы
     * @returns {BEM}
     * @private
     */
    _checkGroupCheckbox: function(items) {
        var visible = 0,
            selected = 0,
            prevMod,
            nextMod;

        if (this._groupTimer != null) {
            this._groupTimer.stop();
        }

        this._groupTimer = u.forEachByChunks(items, {
            size: this._chunkSize,
            delay: this._chunkDelay
        }, function(item) {
            if (!item.hidden) {
                visible++;
                item.selected && selected++;
            }
        }, this);

        this._groupTimer
            .start()
            .then(function() {
                prevMod = this._groupCheckbox.getMod('checked');
                nextMod = selected == visible ? 'yes' : '';

                if (prevMod != nextMod) {
                    this._notToggleAll = true;
                    this._groupCheckbox.setMod('checked', nextMod);
                }
            });


        return this;
    },

    /**
     * Флаг, запрещает выполнение функции _toggleAll
     */
    _notToggleAll: false,

    /**
     * Флаг, не позволяет триггерить change при изменении одного item'a
     */
    _fromGroupCheckbox: false,

    _toggleAllTimer: null,

    /**
     * Меняет модификатор selected у элементов
     * @param {Boolean} isMainChecked - флаг, выбран ли главный checkbox
     * @returns {BEM}
     * @private
     */
    _toggleAll: function(isMainChecked) {
        var changedInstances = [];

        this._fromGroupCheckbox = true;

        if (this._toggleAllTimer != null) {
            this._toggleAllTimer.stop();
        }

        this._toggleAllTimer = u.forEachByChunks(this.elemInstances('item'), {
            size: this._chunkSize,
            delay: this._chunkDelay
        }, function(instance) {
            var isHidden = instance.hasMod('visibility', 'hidden'),
                isDisabled = instance.hasMod('disabled', 'yes'),
                isSelected = instance.hasMod('selected', 'yes');

            if (!isHidden && !isDisabled && isMainChecked != isSelected) {
                instance.toggle(isMainChecked);
                changedInstances.push(instance.getItemParams());
            }
        }, this);

        this._toggleAllTimer
            .start()
            .then(function() {
                this._fromGroupCheckbox = false;
                this.trigger('change', changedInstances);
            });

        return this;
    }

}, {

    live: function() {
        this.__base();

        this
            .liveInitOnBlockEvent('search.finish', 'b-chooser', function(e, data) {
                this._groupCheckbox && this._checkGroupCheckbox(data.items);
            })
            .liveInitOnBlockInsideEvent('change', 'checkbox', function(e, data) {
                var isGroupCheckbox = this._groupCheckbox && this._groupCheckbox.domElem[0] === e.block.domElem[0];

                if (isGroupCheckbox && !this._notToggleAll) {
                    this._toggleAll(data.checked);
                } else {
                    this._notToggleAll = false;
                }
            })
            .liveInitOnBlockInsideEvent('unselect-all', 'b-chooser__unselect-all', function(e, data) {
                this.uncheckAll();
            });
    }

});
