BEM.DOM.decl({ block: 'b-chooser', modName: 'search', modVal: 'yes' }, {

    onSetMod: {
        js: function() {
            this.__base();

            this._childrenCount = this.elemParams(this.elem('wrap')).childrenCount || 0;
        }
    },

    _searchTimer: null,

    /**
     * Создает RegExp из value и запускает поиск на элементах
     * @param {String} value - строка запроса
     * @returns {BEM}
     * @private
     */
    _search: function(value) {
        var query = $.trim(value),
            items = this.elemInstances('item'),
            data = { query: query, regexp: new RegExp(u.escape.regExp(value), 'gi') };

        query || this.delMod('found');

        this.trigger('search', data);

        this._isFound = false;
        this._verifiedCount = 0;

        this.elemInstances('group')
            .forEach(function(instance) {
                instance._search();
            });

        // останавливаем предыдущий поиск
        if (this._searchTimer != null) {
            this._searchTimer.stop();
        }

        this._searchTimer = u.forEachByChunks(items, {
            delay: this._chunkDelay,
            size: this._chunkSize
        }, function(instance) {
            data.query ?
                instance._search(data) :
                instance._reset(data);
        });

        this._searchTimer.start();

        return this;
    },

    /**
     * Закэшированный инпут
     */
    _input: null,

    /**
     * Кэширует input
     * @returns {BEM}
     */
    getInput: function() {
        return this._input || (this._input = this.findBlockInside('search', 'input'));
    },

    /**
     * Запуск поиска снаружи
     * @param {String} value - строка запроса
     * @returns {BEM}
     */
    search: function(value) {
        this.getInput().val(value);

        return this;
    },

    /**
     * Флаг, найдено хоть одно совпадение во время поиска
     */
    _isFound: false,

    /**
     * Количество проверенных элементов первого уровня
     */
    _verifiedCount: 0,

    /**
     * Отлавливает окончание поиска
     * @param {Boolean} isFind - флаг, true значит, что в элементе или его потомках есть удовлетворяющий поиску item
     * @returns {*}
     * @private
     */
    _verifyItemsCount: function(isFind) {
        this._isFound || (this._isFound = isFind);

        // если количество проверенных элементов совпадает с общим количеством элементов
        if (++this._verifiedCount == this._childrenCount) {
            this
                .setMod('found', this._isFound ? '' : 'no')
                .trigger('search.finish', { items: this.getAll() });
        }

        return this;
    },

    /**
     * Создает и добавляет новый item в DOM-дерево
     * @param {Object} item
     *  @param {String} item.name - имя элемента
     *  @param {*} item.content
     *  @param {Object} [item.js]
     *  @param {Object} [item.elemMods]
     * @returns {BEM}
     */
    add: function(item) {
        BEM.DOM.append(this.elem('wrap'), BEMHTML.apply({
            block: 'b-chooser',
            elem: 'item',
            elemMods: item.elemMods,
            mix: item.mix,
            js: item.js,
            name: item.name,
            content: item.content
        }));

        this._childrenCount++;

        return this;
    },

    /**
     * Удаляет item из DOM-дерева
     * @param {String} name - имя элемента item
     * @param {*} [triggerParams]
     * @returns {BEM}
     */
    remove: function(name, triggerParams) {
        var instance = this.elemInstance('item', 'name', name);

        instance && instance.remove(triggerParams);
        this._childrenCount--;

        return this;
    },

    /**
     * Удаляет все item из DOM-дерева
     * @param {*} [triggerParams]
     * @returns {BEM}
     */
    removeAll: function(triggerParams) {
        this.elemInstances('item').forEach(function(instance) {
            instance.remove(triggerParams);
        }, this);

        this._childrenCount = 0;

        return this;
    }

}, {

    live: function() {
        this.__base();

        this.liveInitOnBlockInsideEvent('change', 'input', function(e) {
            this._search(e.block.val());
        });
    }

});
