BEM.DOM.decl({ block: 'b-chooser', modName: 'virtual', modVal: 'yes' }, {

    onSetMod: {
        js: function() {
            this._cacheIndex = {};
            this._prevViewItems = [];
            this._virtualItems = this.params.items || [];
            this._groupCheckbox = this.findBlockInside('select-all', 'checkbox');

            // количество элементов которое будет отрисовываться
            this.params.viewCount && (this._viewCount = this.params.viewCount);

            // количество элементов на которое будет смещено viewCount от верхней границы
            // при поиске элементов которые необходимо отрисовать _getItemsForUpdate
            this.params.stock && (this._stock = this.params.stock);

            this._updateAllDebounce = $.debounce(this.updateAll, this._debounceDelay, this);
            this._delModScrolligDebounce = $.debounce(this._delModScrollig, this._debounceDelay, this);
            this._checkGroupCheckboxDebounce = $.debounce(this._checkGroupCheckbox, this._debounceDelay, this);
            this._repaintCurrentItemsDebounce = $.debounce(this.repaintCurrentItems, this._debounceDelay, this);

            this.updateAll()
                .done(function() {
                    this.elem('wrap')
                        .scroll(this._onScroll.bind(this));

                    if (this._groupCheckbox) {
                        this._checkGroupCheckbox(this._virtualItems);
                    }

                    this.trigger('init-finish');
                });
        }
    },

    _searchTimer: null,

    /**
     * Максимольное количество элементов в chunk для метода forEachByChunks
     */
    _chunkSize: 1000,

    /**
     * Задержка колбэка метода forEachByChunks
     */
    _chunkDelay: 0,

    /**
     * Задержка для debounce
     */
    _debounceDelay: 50,

    /**
     * Количество элементов которые необходимо отрисовать
     */
    _viewCount: 20,

    /**
     * количество элементов на которое будет смещено viewCount от верхней границы
     */
    _stock: 5,

    /**
     * Пересчитывает позиции и перерисовывает элементы
     * @returns {promise}
     */
    updateAll: function() {
        this._showProgress();

        return this._calculatePositions()
            .done(function() {
                this.repaintCurrentItems()
                    ._hideProgress();
            });
    },

    /**
     * Удаляет виртуальный элемент
     * @param {String} name
     */
    removeItem: function(name) {
        if (!name) { return; }

        this._virtualItems = this._virtualItems.reduce(function(result, virtualItem) {
            if (name !== virtualItem.name) {
                result.push(virtualItem);
            }

            return result;
        }, []);

        this._updateAllDebounce();
    },

    /**
     * Возвращает список виртуальной структуры
     * @returns {Array}
     */
    getVirtualItems: function() {
        return this._virtualItems || [];
    },

    /**
     * Замещает список виртуальной структуры
     * @param {Array} virtualItems
     * @returns {BEM}
     */
    setVirtualItems: function(virtualItems) {
        this._virtualItems = virtualItems || [];
        
        return this;
    },

    /**
     * Возвращает список всех выбранных элементов
     * @returns {Array}
     */
    getSelected: function() {
        var _this = this;

        return this._virtualItems.reduce(function(result, item) {
            var itemParams = _this.getItemParams(item);

            if (itemParams.selected) {
                result.push(itemParams);
            }

            return result;
        }, []);
    },

    /**
     * Показывает spinner
     * @returns {BEM}
     * @private
     */
    _showProgress: function() {
        this.getSpinner()
            .setMod('progress', 'yes');

        return this.setMod('progress', 'yes');
    },

    /**
     * Скрывает spinner
     * @returns {BEM}
     * @private
     */
    _hideProgress: function() {
        this.getSpinner()
            .delMod('progress');

        return this.delMod('progress');
    },

    /**
     * Строит и кэширует блок spinner
     * @returns {BEM}
     */
    getSpinner: function() {
        if (this._spinner) {
            return this._spinner;
        }

        return this._spinner = this.findBlockInside(
            BEM.DOM.append(this.domElem, BEMHTML.apply({
                block: 'spin',
                mods: { theme: 'gray-48' },
                mix: {
                    block: 'b-chooser',
                    elem: 'spin'
                },
                js: true
            })), 'spin');
    },

    _scrollTimer: null,

    _delModScrollig: function() {
        this.delMod('scrollig');
    },

    /**
     * Обновляем элементы относительно положения скролла
     * @private
     */
    _onScroll: function() {
        // устанавливает всем элементам item pointer-events: none;
        // облегчает скролл, т.к. на это время отключает ховер
        if (!this.hasMod('scrollig', 'yes')) {
            this.setMod('scrollig', 'yes');
        }

        // Событие scroll отрабатывает очень часто, на все эти частые вызовы мы ставим модификатор scrollig_yes(если его нет),
        // таймер позволяет удалить модификатор scrollig_yes один раз, когда закончили скроллить
        this._delModScrolligDebounce();
        this._updateViewItems();
    },

    /**
     * Считает расположение каждого элемента, по name элемента кэширует индекс
     * @returns {promise}
     * @private
     */
    _calculatePositions: function() {
        var position = 0;

        return u.forEachByChunks(this._virtualItems, {
            delay: this._chunkDelay,
            size: this._chunkSize
        }, function(item, index) {
            var outerHeight = item.height;

            // пропускаем скрытые элементы
            if (item.elemMods.visibility === 'hidden') {
                item.position = -Infinity;
                item.outerHeight = -Infinity;
            } else {
                item.position = position;
                item.outerHeight = outerHeight;

                position += outerHeight;
            }

            this._cacheIndex[item.name] = index;
        }, this)
            .start()
            .done(function() {
                this._appendFakeHeight(position);
            });
    },

    /**
     * Добавляет div с отступом, который растягивает обертку со скроллом
     * @param {Number} position
     * @returns {BEM}
     * @private
     */
    _appendFakeHeight: function(position) {
        this.findElem('fake-height').remove();

        BEM.DOM.append(this.elem('wrap'), BEMHTML.apply({
            block: 'b-chooser',
            elem: 'fake-height',
            attrs: { style: 'margin-top:' + position + 'px' }
        }));

        return this;
    },

    /**
     * Содержит список отрисованных элементов
     */
    _prevViewItems: null,

    /**
     * Сортирует элементы по действиям
     * @param {Array} current - текущие отрисованные элементы
     * @param {Array} challengers - элементы которые должны быть отображены
     * @returns {{
     *      toAdd: Array,
     *      toRemove: Array,
     *      noChange: Array
     *  }}
     * @private
     */
    _sortForActions: function(current, challengers) {
        var toAdd = [],
            toRemove = [],
            noChange = [];

        // находим пересечение между отрисованными и которые должны быть отображены
        // пересечение записывается в noChange, остальные на удаление
        current.forEach(function(currentItem) {
            var isContain = challengers.some(function(challenger) {
                return challenger.position === currentItem.params.position;
            });

            isContain ?
                noChange.push(currentItem) :
                toRemove.push(currentItem);
        });

        // которые должны быть отображены - отрисованные = новые которые нужно отрисовать
        challengers.forEach(function(challenger) {
            var isContain = current.some(function(currentItem) {
                return challenger.position === currentItem.params.position;
            });

            !isContain && toAdd.push(challenger);
        });

        return {
            toAdd: toAdd,
            toRemove: toRemove,
            noChange: noChange
        };
    },

    /**
     * Рисует новые элементы относительно текущего положения скролла
     * @returns {BEM}
     * @private
     */
    _updateViewItems: function() {
        var actions = this._sortForActions(this._prevViewItems, this._getItemsForUpdate() || []);

        this._prevViewItems = actions.noChange;

        actions.toRemove.forEach(function(item) {
            this.elemInstance(item.domElem).destruct();
        }, this);

        actions.toAdd.forEach(function(item) {
            this._prevViewItems.push({
                domElem: this._appendItem(item),
                params: item
            });
        }, this);

        return this;
    },

    _itemKeys: ['block', 'elem', 'elemMods', 'mix', 'js', 'attrs', 'content', 'name'],

    /**
     * Строит элемент и добавляет в DOM
     * @param {object} item
     * @returns {domElem}
     * @private
     */
    _appendItem: function(item) {
        var itemTree = u._.pick(item, this._itemKeys),
            domElem;

        u._.extend(itemTree, {
            attrs: {
                style: [
                    'top:' + item.position + 'px',
                    'height:' + item.outerHeight + 'px'
                ].join(';')
            }
        });

        domElem = BEM.DOM.append(this.elem('wrap'), BEMHTML.apply(itemTree));

        // подсвечиваем элемент, если это результат поиска
        if (item._searchData) {
            this.elemInstance(domElem)._highlight(item._searchData);
        }

        return domElem;
    },

    /**
     * Находит элементы которые необходимо отрисовать
     * @returns {Array}
     * @private
     */
    _getItemsForUpdate: function() {
        var virtualItems = this._virtualItems,
            scrollTop = this.elem('wrap').scrollTop(),
            viewCount = this._viewCount,
            stock = this._stock,
            visibleCacheIndexes = [],
            result = [],
            from = 0,
            index,
            item;

        // кэшируем индексы видимых элементов
        for (index = 0; index < virtualItems.length; index++) {
            item = virtualItems[index];

            if (item.elemMods.visibility !== 'hidden') {
                visibleCacheIndexes.push(index);
            }
        }

        // если нет видимых элеметов
        if (!visibleCacheIndexes.length) {
            return [];
        }

        // если положения скролла меньше первого видимого элемента
        if (scrollTop <= virtualItems[visibleCacheIndexes[0]].position) {
            from = 0;
        } else {
            // ищем индекс с которого будем собирать элементы для отрисовки
            visibleCacheIndexes.some(function(virtualIndex, cacheIndexes) {
                var item = virtualItems[virtualIndex],
                    inviewport = scrollTop >= item.position && scrollTop <= item.position + item.outerHeight;

                if (inviewport) {
                    // берем элементы с запасом
                    from = cacheIndexes - stock;

                    if (from < 0) {
                        from = 0;
                    }
                }

                return inviewport;
            });
        }

        // собираем элементы для отрисовки
        for (; result.length <= viewCount && from < visibleCacheIndexes.length; from++) {
            result.push(virtualItems[visibleCacheIndexes[from]]);
        }

        return result;
    },

    /**
     * Возвращает параметры всех элементов
     * @returns {Array}
     */
    getAll: function() {
        return this._virtualItems.map(function(item) {
            return this.getItemParams(item);
        }, this);
    },

    /**
     * Меняет состояние selected
     * @param {Boolean} isMainChecked
     * @returns {BEM}
     */
    _toggleAll: function(isMainChecked) {
         var changedInstances = [];

         this._virtualItems.forEach(function(item) {
             var isHidden = item.elemMods.visibility === 'hidden',
                 isDisabled = item.elemMods.disabled === 'yes',
                 isSelected = item.elemMods.selected === 'yes';

             if (!isHidden && !isDisabled && isMainChecked !== isSelected) {
                 item.elemMods.selected = isMainChecked ? 'yes' : '';

                 changedInstances.push(this.getItemParams(item));
             }

             // не должно быть после групповых действий состояние indeterminate
             if (!isHidden && !isDisabled && isMainChecked) {
                item.elemMods.indeterminate = '';
             }
         }, this);

         this.repaintCurrentItems();

        if (changedInstances.length) {
            // некрасиво, но групповых действий меняем формат данных change
            this.trigger('change', {
                fromGroupCheckbox: true,
                changedItems: changedInstances,
                searchValue: this.getInput() && this.getInput().val()
            });
        }

         return this;
     },

    /**
     * Находит и кэширет блок поискового инпута
     * @returns {BEM}
     */
    getInput: function() {
        return this._input || (this._input = this.findBlockInside('search', 'input'));
    },

    /**
     * Перерисовывает текущие видимые элементы
     * @returns {BEM}
     */
    repaintCurrentItems: function() {
        this._prevViewItems.forEach(function(item) {
            this.elemInstance(item.domElem).destruct();
        }, this);

        this._prevViewItems = [];

        return this._updateViewItems();
    },

    /**
     * Возвращает параметры элемента в формате b-chooser__item
     * @param {Array} virtualItem
     * @param {Object} extraParams
     */
    getItemParams: function(virtualItem, extraParams) {
        var params = u._.extend({}, virtualItem.js);

        params.indeterminate = virtualItem.elemMods.indeterminate == 'yes';
        params.selected = virtualItem.elemMods.selected === 'yes';
        params.disabled = virtualItem.elemMods.disabled === 'yes';
        params.hidden = virtualItem.elemMods.visibility === 'hidden';

        return u._.extend({ extraParams: extraParams || {} }, params);
    },

    /**
     * Возвращает параметры элемента по name
     * @param {String} name
     * @returns {BEM}
     */
    getItem: function(name) {
        return this.getItemParams(this._virtualItems[this._cacheIndex[name]]);
    },

    /**
     * Устанавливает модификатор indeterminate
     * @param {String} name
     * @param {Object} triggerParams
     * @returns {BEM}
     */
    setIndeterminate: function(name, triggerParams) {
        return this
            ._onItemChange({ name: name, selected: true, indeterminate: true }, triggerParams)
            ._repaintCurrentItemsDebounce();
    },

    /**
     * Делает элемент выбранным
     * @param {String} name
     * @param {Object} triggerParams
     * @returns {*}
     */
    check: function(name, triggerParams) {
        return this
            ._onItemChange({ name: name, selected: true }, triggerParams)
            ._repaintCurrentItemsDebounce();
    },

    /**
     * Делает элемент не выбранными
     * @param {String} name
     * @param {Object} triggerParams
     * @returns {*}
     */
    uncheck: function(name, triggerParams) {
        return this
            ._onItemChange({ name: name, selected: false }, triggerParams)
            ._repaintCurrentItemsDebounce();
    },

    /**
     * Меняет состояние selected виртуального элемента
     * @param {Object} data
     * @param {Object} triggerParams
     * @returns {BEM}
     * @private
     */
    _onItemChange: function(data, triggerParams) {
        var cacheIndex = this._cacheIndex[data.name],
            virtualItem;

        if (typeof cacheIndex === 'number') {
            virtualItem = this._virtualItems[cacheIndex];

            // если элемент не меняется то незачем триггерить change
            if (!!virtualItem.elemMods.selected !== data.selected ||
                !!virtualItem.elemMods.indeterminate !== data.indeterminate) {

                u._.extend(virtualItem.elemMods, {
                    selected: data.selected ? 'yes' : '',
                    indeterminate: data.indeterminate ? 'yes' : ''
                });

                if (this._groupCheckbox) {
                    this._checkGroupCheckboxDebounce(this._virtualItems);
                }

                this.trigger('change', this.getItemParams(virtualItem, triggerParams));
            }
        }

        return this;
    },

    _checkGroupCheckboxDebounce: null,

    /**
     * Выставляет правильный модификатор checked главному checkbox
     * @param {Array} items
     * @returns {BEM}
     * @private
     */
    _checkGroupCheckbox: function(items) {
        var visible = 0,
            selected = 0,
            prevMod,
            nextMod;

        items.forEach(function(item) {
            if (item.elemMods.visibility !== 'hidden') {
                item.elemMods.selected && selected++;
                visible++;
            }
        });

        prevMod = this._groupCheckbox.getMod('checked');
        nextMod = selected == visible && visible != 0 ? 'yes' : '';

        if (prevMod != nextMod) {
            this._notToggleAll = true;
            this._groupCheckbox.setMod('checked', nextMod);
        }

        return this;
    },

    /**
     * Создает RegExp из value и запускает поиск на элементах
     * @param {String} value
     * @returns {BEM}
     * @private
     */
    _search: function(value) {
        this._showProgress();

        var query = $.trim(value),
            items = this._virtualItems,
            data = { query: query, regexp: new RegExp(u.escape.regExp(value), 'gi') };

        query || this.delMod('found');

        this.trigger('search', data);

        this._isFound = false;

        // останавливаем предыдущий поиск
        if (this._searchTimer != null) {
            this._searchTimer.stop();
        }

        this._searchTimer = u.forEachByChunks(items, {
            delay: this._chunkDelay,
            size: this._chunkSize
        }, function(item) {
            data.query ?
                this._searchOnVirtualItem(data, item) :
                this._resetVirtualItem(data, item);
        }, this);

        this._searchTimer
            .start()
            .then(function() {
                return this._calculatePositions();
            })
            .then(function() {
                this.repaintCurrentItems()
                    ._checkGroupCheckbox(items)
                    ._hideProgress();

                data.query ?
                    this.setMod('found', this._isFound ? '' : 'no') :
                    this.delMod('found');
            });

        return this;
    },

    /**
     * Поиск на текущем элементе
     * @param {Object} data
     * @param {Object} item
     * @returns {BEM}
     * @private
     */
    _searchOnVirtualItem: function(data, item) {
        var isFind = false,
            searchParams = item.js.search;

        if (!item.elemMods.disabled) {
            if (searchParams) {
                u._.keys(searchParams)
                    .forEach(function(key) {
                        isFind || (isFind = data.regexp.test(searchParams[key]));
                    });
            }
        }

        this._isFound || (this._isFound = isFind);

        if (isFind) {
            item.elemMods.visibility = '';
            item._searchData = data;
        } else {
            item.elemMods.visibility = 'hidden';
            item._searchData = undefined;
        }

        return this;
    },

    /**
     * Сбрасывает item в начальное состояние
     * @param {Object} data
     * @param {Object} item
     * @returns {BEM}
     * @private
     */
    _resetVirtualItem: function(data, item) {
        if (!item.elemMods.disabled) {
            item.elemMods.visibility = '';
            item._searchData = undefined;
        }

        return this;
    }


}, {

    live: function() {
        this.__base();

        return false;
    }

});
