block('b-date-input')(
    tag()('span'),

    js()(function() {
        return {
            value: this.ctx.value,
            dateFormat: this.ctx.dateFormat,
            viewFormat: this.ctx.viewFormat || this.ctx.dateFormat
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            mods = this.mods,
            inputAttrs = {
                type: 'hidden',
                name: ctx.name,
                value: ctx.value || '',
                autocomplete: 'off'
            };

        if (mods.disabled) inputAttrs.disabled = 'disabled';

        return [
            {
                block: 'input',
                mix: [{
                    block: 'b-date-input',
                    elem: 'input'
                }],
                js: {
                    format: ctx.viewFormat || ctx.dateFormat,
                    calendarMix: ctx.calendarMix,
                    earlierLimit: ctx.earlierLimit,
                    laterLimit: ctx.laterLimit,
                    popupDirections: ctx.popupDirections,
                    popupMix: ctx.popupMix
                },
                mods: {
                    'has-calendar': 'yes',
                    readonly: 'yes',
                    disabled: mods.disabled,
                    'has-clear': mods['has-clear'],
                    adaptive: mods.adaptive,
                    size: mods.size,
                    theme: mods.theme
                },
                content: { elem: 'control' },
                placeholder: ctx.placeholder
            },
            {
                tag: 'input',
                elem: 'hidden',
                attrs: inputAttrs
            }
        ];
    })
);
