BEM.DOM.decl('b-date-input', {
    onSetMod: {
        js: function() {
            var params = this.params;

            this.input = this.findBlockInside('input');
            this.hidden = this.elem('hidden');

            this.input.val(params.value ? u.moment(params.value, params.dateFormat).format(params.viewFormat) : '');
        },

        disabled: function(modName, modValue) {
            this.input.setMod('disabled', modValue);
            this.hidden.prop('disabled', modValue === 'yes');
        }
    },


    /**
     * Получить или установить значение
     * @param {String} value значение, в формате dateFromat
     * @returns {String}
     */
    val: function(value) {
        var params = this.params;

        if (typeof value != 'undefined')
            this.input.val(value ? u.moment(value, params.dateFormat).format(params.viewFormat) : '');

        return this.hidden.val.apply(this.hidden, arguments);
    },

    /**
     * Устанавливает границы выбора даты
     * @param {Date} earlier нижняя граница выбора
     * @param {Date} later верхняя граница выбора
     */
    setLimits: function(earlier, later) {
        this.input.setLimits.apply(this.input, arguments);
    },

    /**
     * Обработчик события выбора даты
     * @param {Event} event событие
     * @param {Date} date выбранная дата
     * @private
     */
    _onInputChoose: function(event, date) {
        var dateStr = date ? this._formatDate(date) : '';

        this.hidden.val(dateStr);
        this.trigger('change', dateStr)
    },

    /**
     * Приводит дату к строке, согласно текущей настройке формата
     * @param {Date|String} date дата
     * @returns {String}
     * @private
     */
    _formatDate: function(date) {
        return u.moment(date).format(this.params.dateFormat);
    },

    /**
     * Обработчик прихода и ухода фокуса у инпута
     * @param {jQuery.Event} e
     * @private
     */
    _onInputFocusBlur: function(e) {
        this.trigger(e.type);
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('choose', 'input', function(e, data) {
                this._onInputChoose(e, data);
            })
            .liveInitOnBlockInsideEvent('focus blur', 'input', function(e) {
                this._onInputFocusBlur(e);
            });

        return false;
    }

});



