/**
 * Блок настройки "Дневного бюджета" кампании
 */
block('b-day-budget2-settings')(
    def()(function() {

        return applyNext({
            walletInfo: this.ctx.walletInfo || {}
        });
    }),

    js()(function() {

        return {
            maxDailyChangeCount: this.ctx.maxDailyChangeCount,
            sum: this.ctx.sum,
            mode: this.ctx.showMode,
            timesChangedToday: this.ctx.timesChangedToday,
            isSet: this.ctx.isSet,
            currency: this.ctx.currency,
            walletDayBudgetSettings: this.walletInfo.dayBudgetSettings || {},
        };
    }),

    content()(function() {
        var walletDayBudgetSettings = this.walletInfo.dayBudgetSettings || {},
            showModeValues = {
                default : iget2('b-day-budget2-settings', 'standartnyy', 'стандартный'),
                stretched: iget2('b-day-budget2-settings', 'raspredelyonnyy', 'распределённый')
            };

        return [
            walletDayBudgetSettings.sum > 0 && {
                elem: 'notice',
                content: iget2(
                    'b-day-budget2-settings',
                    'v-nastroykah-walletlink-obshchego',
                    'В настройках {walletLink} задан режим показа "{showMode}" и дневной бюджет для всех кампаний {sum}',
                    {
                        walletLink: {
                            block: 'link',
                            url: this.walletInfo.url,
                            target: '_blank',
                            text: iget2('b-day-budget2-settings', 'obshchego-schyota', 'общего счёта')
                        },

                        sum: u.currencies.formatSum(this.ctx.currency, walletDayBudgetSettings.sum),
                        showMode: showModeValues[walletDayBudgetSettings.showMode],
                        context: 'walletLink - общего счёта; showMode - распределённый; sum - 2000 руб.'
                    }
                )
            },
            {
                elem: 'title'
            },
            {
                elem: 'collapsing-area',
                content: [
                    {
                        block: 'input',
                        mods: { clear: 'no' },
                        mix: [
                            {
                                block: 'b-hintable',
                                js: true
                            },
                            {
                                block: 'b-day-budget2-settings',
                                elem: 'prevalidate-input',
                                js: {
                                    modelField: 'sum'
                                }
                            },
                            {
                                block: 'b-day-budget2-settings',
                                elem: 'model-field',
                                js: {
                                    name: 'sum',
                                    type: 'formatted-input'
                                }
                            }
                        ],
                        content: { elem: 'control' }
                    },
                    {
                        elem: 'currency',
                        content: u.currencies.getName(this.ctx.currency)
                    },
                    iget2('b-day-budget2-settings', 'rezhim-pokaza', 'режим показа'),
                    '&nbsp;',
                    {
                        block: 'select',
                        mix: [
                            {
                                block: 'b-day-budget2-settings',
                                elem: 'model-field',
                                js: {
                                    name: 'mode',
                                    type: 'select'
                                }
                            }
                        ],
                        content: [
                            { block: 'button' },
                            {
                                elem: 'control',
                                content: u._.map(showModeValues, function(value, key) {

                                    return {
                                        elem: 'option',
                                        attrs: { value: key },
                                        content: value
                                    };
                                })
                            }
                        ]
                    }
                ]
            },
            { elem: 'errors' }
        ];
    }),

    elem('title').content()(function() {
        return {
            block: 'checkbox',
            mix: [
                {
                    block: 'b-day-budget2-settings',
                    elem: 'model-field',
                    js: {
                        name: 'dayBudgetEnabled',
                        type: 'checkbox'
                    }
                }
            ],
            text: iget2('b-day-budget2-settings', 'dnevnoy-byudzhet', 'Дневной бюджет')
        };
    })
);
