BEM.DOM.decl({ name: 'b-day-budget2-settings', baseBlock: 'i-glue' }, {

    onSetMod: {

        js: function() {
            var params = this.params;

            this.__base.apply(this, arguments);
            this._subscriptionManager = BEM.create('i-subscription-manager');

            this.model.update({
                currency: params.currency,
                dayBudgetEnabled: params.isSet,
                sum: params.sum,
                mode: params.mode,
                todayChangingCount: params.timesChangedToday
            });

            this.setMod('collapsed', this.model.get('dayBudgetEnabled') ? '' : 'yes');

            this.findBlockInside('checkbox').on('change', function(e) {
                var maxDailyChangeCount = params.maxDailyChangeCount,
                    checkbox = e.block,
                    wasChanged = true;

                // попытка включить дневной бюджет, когда уже нельзя
                if (checkbox.isChecked() && this.model.get('todayChangingCount') >= maxDailyChangeCount && !params.isSet) {
                    this._onMaximumDailyChangeCountExceed && this._onMaximumDailyChangeCountExceed(function() {
                        this.model.set('dayBudgetEnabled', false);
                        wasChanged = false;
                    }.bind(this));
                } else {
                    this.setMod('collapsed', checkbox.isChecked() ? '' : 'yes');
                }

                if (wasChanged) {
                    this._triggerChange();
                }
            }, this);

            this._sumField = this.findBlockInside('input');
            this._sumField.on('change', function(e, data) {
                var maxDailyChangeCount = params.maxDailyChangeCount,
                    wasChanged = true;

                // проверяем, что изменение было и что ДБ не был выключен
                if (this.model.get('todayChangingCount') >= maxDailyChangeCount &&
                    this.model.get('sum') != params.sum && params.isSet) {
                    this._onMaximumDailyChangeCountExceed && this._onMaximumDailyChangeCountExceed(function() {
                        this.model.update(params.sum);
                        this.findBlockInside('input').val(params.sum);
                        wasChanged = false;
                    }.bind(this));
                }

                if (wasChanged) {
                   this._triggerChange();
                }
            }, this);

            this._initWalletRestrictionHint();

            this.model.on('mode', 'change', this._triggerChange, this);

            this.model.on('change', function() {
                this.clearErrorMessages();
            }, this);

            this._subscriptionManager.wrap(BEM.blocks['input'])
                .on(this.elem('prevalidate-input'), 'blur', function(e) {
                    this._validateField(e.block);
                }, this);
        },

        collapsed: function(modName, modVal) {
            if (modVal == '') {
                // стандартный воркэраунд для фокуса в ивенте - хромиум слишком сильно ускоряет триггер ивента
                setTimeout(function() { this.findBlockInside('input').elem('control').focus(); }.bind(this), 100);
            }
        }

    },

    /**
     * кеширует обработчик события превышения количества допустимых установок ДБ
     * @param event
     */
    setOnMaximumClicksExceededEvent: function(event) {
        this._onMaximumDailyChangeCountExceed = event;
    },

    /**
     * Валидирует форму настройки дневного бюджета
     * @returns {Boolean}
     */
    validate: function() {
        var validation = this.model.validate(),
            errors = validation.errors;

        if (!validation.valid) {
            BEM.DOM.update(
                this.elem('errors'),
                BEMHTML.apply({
                    block: 'b-strategy2-settings',
                    elem: 'error',
                    content: errors[0] && errors[0].text
                }));
            this._hasErrors = true;
        } else {
            this.clearErrorMessages();
        }

        return validation.valid;
    },

    /**
     * Очищает сообщения об ошибка валидации
     * @returns {BEM}
     */
    clearErrorMessages: function() {
        if (this._hasErrors) {
            BEM.DOM.update(this.elem('errors'), '');
            this._hasErrors = false;
        }

        return this;
    },

    /**
     * Получить настройки дневного бюджета
     * @returns {Object}
     */
    getData: function() {
        var model = this.model;

        return {
            active: model.get('dayBudgetEnabled'),
            set: !!(model.get('dayBudgetEnabled') && (model.get('sum') > 0)),
            sum: model.get('sum') || '',
            show_mode: model.get('mode')
        };
    },

    /**
     * установка значения дневного бюджета извне
     * @param {String} name - имя поля
     * @param {String|Boolean|Integer} value - значение поля
     */
    setData: function(name, value) {
        this.model.set(name, value);
    },

    /**
     * Очистка формы настройки дневного бюджета
     */
    reset: function(params) {
        var data = params === undefined ? this.params : params;

        this.model.update({
            currency: data.currency,
            dayBudgetEnabled: data.isSet,
            sum: data.sum,
            mode: data.showMode,
            todayChangingCount: data.timesChangedToday
        });
    },

    /**
     * Деструктор
     * если модель не удалять, то при перерисовке блока настроек
     * не дернется change при инициализации модели
     * и данные не отобразятся
     */
    destruct: function() {
        this._tipman && this._tipman.destruct();

        this._subscriptionManager.dispose();
        this._subscriptionManager.destruct();
        this.model.destruct();

        return this.__base.apply(this, arguments);
    },

    /**
     * Дергает событие change дневного бюджета
     * @private
     */
    _triggerChange: function() {
        this.trigger('change', this.getData());
    },

    /**
     * Инициализирует предупреждающий хинт о заданной сумме дневного бюджета на ОС
     * @private
     */
    _initWalletRestrictionHint: function() {
        if (!this.params.walletDayBudgetSettings.sum || this.params.walletDayBudgetSettings.sum == 0) {
            return;
        }

        this._sumField.on('focus change', function() {
            if (this.params.walletDayBudgetSettings.sum < this.model.get('sum')) {
                this._showWalletRestrictionHint();
            } else {
                this._hideWalletRestrictionHint();
            }
        }, this);

        this._sumField.on('blur', function() {
            this._hideWalletRestrictionHint();
        }, this);
    },

    /**
     * Показывает предупреждающий хинт о заданной сумме дневного бюджета на ОС
     * @private
     */
    _showWalletRestrictionHint: function() {
        if (!this._tipman) {
            this._tipman = BEM.create('tipman', {
                tipMods: { theme: 'normal' },
                tipJs: { to: ['bottom', 'top'] },
                popupMods: { 'on-scroll': 'close' },
                delay: 50
            });
        }

        this._tipman.show({
            owner: this._sumField.domElem,
            content: iget2(
                'b-day-budget2-settings',
                'ukazhite-znachenie-menshe-s',
                'Укажите значение меньше {foo},<br/>чтобы ограничить дневной бюджет кампании',
                {
                    foo: u.currencies.formatSum(this.params.currency, this.params.walletDayBudgetSettings.sum)
                }
            )
        });
    },

    /**
     * Скрывает предупреждающий хинт о заданной сумме дневного бюджета на ОС
     * @private
     */
    _hideWalletRestrictionHint: function() {
        this._tipman && this._tipman.hide();
    },

    /**
     * Валидирует поле модели, подсвечивает его или снимает подсветку в зависимости от состояния,
     * зададает текст подсказки об ошибки, если он есть
     * @param {BEM} input - блок инпута, который необходимо валидировать
     * @returns {Boolean}
     */
    _validateField: function(input) {
        var hintBlock = this.findBlockOn(input.domElem, 'b-hintable'),
            val = input.val(),
            params = this.elemParams(this.elemify(input.domElem, 'prevalidate-input')),
            fieldValidationResult,
            isFieldValid,
            warnings;

        if (this.model.get(params.modelField) == undefined) {
            return;
        }

        fieldValidationResult = this.model.validate(params.modelField);

        isFieldValid = (val === '') || !!fieldValidationResult.valid;

        // ошибочное поле
        input.toggleMod('error', 'yes', !isFieldValid);

        if (!val) {
            warnings = '';
        } else if (!isFieldValid) {
            var errText = [];

            fieldValidationResult.errors.map(function(error) {
                errText.push(error.text.value || error.text);
            });

            warnings = errText.join('</br>');
        }

        hintBlock.setHintContent(warnings);

        return isFieldValid;
    },
});
