/**
 * View Model блока настройки "Дневного бюджета"
 */
BEM.MODEL.decl({ model: 'b-day-budget2-settings' }, {

    // Валюта
    currency: {
        type: 'string'
    },

    // Включен ли Дневной бюджет
    dayBudgetEnabled: {
        type: 'boolean'
    },

    // Сумма
    sum: {
        type: 'optional-blank-number',
        dependsFrom: ['currency'],
        validation: function() {
            return this.validationSum()
        }
    },

    // Режим показа
    mode: {
        type: 'enum',
        enum: [
            'default',
            'stretched'
        ]
    },

    // Количество изменений за сегодня
    todayChangingCount: {
        type: 'number'
    }

}, {

    validationSum: function() {
        var currencyId = this.get('currency') || 'YND_FIXED',
            currency = u.currencies.get(currencyId);

        return {
            rules: {
                required: {
                    text: iget2('b-day-budget2-settings', 'ne-ukazana-summa-dnevnogo', 'Не указана сумма дневного бюджета'),
                    validate: function(val) {
                        return !!val;
                    }
                },
                type: {
                    text: iget2('b-day-budget2-settings', 'neverno-ukazana-summa-dnevnogo', 'Неверно указана сумма дневного бюджета'),
                    needToValidate: function() {
                        return !!this.get('sum');
                    }
                },
                lte: {
                    value: currency.MIN_DAY_BUDGET,
                    text: iget2('b-day-budget2-settings', 'summa-dnevnogo-byudzheta-ne', 'Сумма дневного бюджета не может быть меньше {foo}', {
                        foo: u.currencies.formatConst(currencyId, 'MIN_DAY_BUDGET')
                    }),
                    needToValidate: function() {
                        return !!this.get('sum');
                    }
                },
                gte: {
                    value: currency.MAX_DAILY_BUDGET_AMOUNT,
                    text: iget2('b-day-budget2-settings', 'summa-dnevnogo-byudzheta-ne-101', 'Сумма дневного бюджета не может быть больше {foo}', {
                        foo: u.currencies.formatConst(currencyId, 'MAX_DAILY_BUDGET_AMOUNT')
                    }),
                    needToValidate: function() { return !!this.get('sum') }
                }
            },

            needToValidate: function() {
                return this.get('dayBudgetEnabled');
            }
        };
    }

});
