block('b-edit-bid-control')(

    def()(function(){
        var currentValue = this.ctx.value;

        return applyNext({
            'ctx.maxUpValue': this.ctx.maxUpValue || 1200,
            'ctx.maxDownValue': this.ctx.maxDownValue || 100,
            'ctx.mode': currentValue == undefined ?
                (this.ctx.isCommon ? 'noValue' : 'up') :
                (currentValue < 0 ? 'down' : 'up')
        });
    }),

    js()(function() {
        return {
            modelName: 'b-edit-bid-control',
            modelData: {
                isCommon: this.ctx.isCommon,
                maxUpValue: this.ctx.maxUpValue,
                maxDownValue: this.ctx.maxDownValue,
                mode: this.ctx.mode,
                value: this.ctx.value && Math.abs(this.ctx.value)
            }
        }
    }),

    content()(function() {
        var modeOptions = [
                this.ctx.isCommon && {
                    elem: 'option',
                    attrs: { value: 'noValue' },
                    content: '—'
                },
                {
                    elem: 'option',
                    attrs: { value: 'up' },
                    content: iget2('b-edit-bid-control', 'uvelichit', 'увеличить')
                },
                {
                    elem: 'option',
                    attrs: { value: 'down' },
                    content: iget2('b-edit-bid-control', 'umenshit', 'уменьшить')
                }
            ],
            currentMode = this.ctx.mode,
            hintValue = '';

        if (currentMode == 'up') {
            hintValue = this.ctx.maxUpValue;
        } else if (currentMode == 'down') {
            hintValue = this.ctx.maxDownValue;
        }

        modeOptions.forEach(function(option) {
            option && (option.attrs.value == currentMode) && (option.attrs.selected = 'selected');
        }, this);

        return iget2('b-edit-bid-control', 'select-uvelichit-umenshit-na', '{select} на {input} %', {
            select: {
                block: 'select',
                mods: {
                    size: 's',
                    theme: 'normal'
                },
                mix: [
                    {
                        block: 'b-edit-bid-control',
                        elem: 'mode'
                    },
                    {
                        block: 'b-edit-bid-control',
                        elem: 'model-field',
                        js: {
                            name: 'mode',
                            type: 'select'
                        }
                    }
                ],
                content: [
                    {
                        block: 'button',
                        mix: {
                            block: 'b-edit-bid-control',
                            elem: 'mode-button'
                        }
                    },
                    {
                        elem: 'control',
                        content: modeOptions
                    }
                ]
            },

            input: {
                block: 'input',
                mix: [
                    {
                        block: 'b-edit-bid-control',
                        elem: 'value'
                    },
                    {
                        block: 'b-edit-bid-control',
                        elem: 'model-field',
                        js: {
                            name: 'value',
                            type: 'input'
                        }
                    }
                ],
                mods: {
                    size: 's',
                    theme: 'normal',
                    clear: 'no'
                },
                value: this.ctx.value != undefined ? Math.abs(this.ctx.value) : '',
                placeholder: !!hintValue ? iget2('b-edit-bid-control', 'max-s', 'max {foo}', {
                    foo: hintValue
                }) : '',
                content: [
                    {
                        elem: 'control',
                        mix: [
                            {
                                block: 'b-edit-bid-control',
                                elem: 'model-field',
                                js: {
                                    type: 'attribute',
                                    name: 'inputHint',
                                    attributeName: 'placeholder'
                                }
                            }
                        ]
                    }
                ]
            },

            context: 'select - увеличить,уменьшить'
        });
    })
);
