/**
 * @event b-edit-region-bid#validated
 * @type {Object} validation данные результатов валидации
 *
 * @fires b-edit-region-bid#change событие изменения значения ставки
 * @fires b-edit-region-bid#validated событие валидации контролов ставки
 */

BEM.DOM.decl({ name: 'b-edit-bid-control', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._bidValueInput = this.findBlockInside('value', 'input');
            this._modeSelect = this.findBlockInside('mode', 'select');

            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._bindModelEvents();

            this._subscriptionManager.on(this._modeSelect, 'change', function() {
                this._bidValueInput.setMod('focused', 'yes');
            }, this);
        },

        focused: {
            'yes': function() {
                this._bidValueInput.setMod('focused', 'yes');
            }
        }
    },

    /**
     * Возвращает выбранные значения контролов установки ставки
     * @returns {{value: Number, mode: ('up'|'down'|'noValue'), absValue: Number}}
     */
    getData: function() {
        var currentMode = this.model.get('mode'),
            bidAbsValue = this.model.get('value');

        return {
            value: currentMode === 'down' ? -bidAbsValue : bidAbsValue,
            mode: currentMode,
            absValue: bidAbsValue
        };
    },

    /**
     * Удаляет блок и подписки на события
     */
    destruct: function() {
        this._subscriptionManager.dispose();

        return this.__base.apply(this, arguments);
    },

    /**
     * Подписываемся на изменения полей модели ставки
     * и на её валидацию
     * @private
     */
    _bindModelEvents: function() {
        this._subscriptionManager.wrap(this.model)
            .on('value', 'change', this._onControlModelChange, this)
            .on('mode', 'change', this._onControlModelChange, this)
            .on('validated', this._onValidated, this);
    },

    /**
     * Обработчик валидации модели ставки
     * @param {Event} e
     * @param {Object} validation
     * @private
     */
    _onValidated: function(e, validation) {
        this.trigger('validated', validation);

        validation.errors ?
            this._showErrors() :
            this._hideErrors();
    },

    /**
     * Обработчик изменения полей модели ставки
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onControlModelChange: function(e, data) {
        this.trigger('change');

        this.model.validate();
    },

    /**
     * Показывает ошибки валидации
     * @private
     */
    _showErrors: function() {
        this._bidValueInput.setMod('error', 'yes');
    },

    /**
     * Скрывает ошибки валидации
     * @private
     */
    _hideErrors: function() {
        this._bidValueInput.delMod('error');
    }
});
