BEM.MODEL.decl('b-edit-bid-control', {
    // является ли контрол групповым
    isCommon: {
        type: 'boolean'
    },

    // наиболешее значение ставки при выбранном mode: увеличить
    maxUpValue: {
        type: 'number'
    },

    // наиболешее значение ставки при выбранном mode: уменьшить
    maxDownValue: {
        type: 'number'
    },

    mode: {
        type: 'enum',
        enum: ['up', 'down', 'noValue']
    },

    maxValue: {
        type: 'number',
        dependsFrom: 'mode',
        calculate: function(mode) {

            return {
                up: this.get('maxUpValue'),
                down: this.get('maxDownValue')
            }[mode] || null;
        }
    },

    inputHint: {
        type: 'string',
        dependsFrom: 'maxValue',
        calculate: function(maxValue) {
            return this.get('mode') === 'noValue' ? '' : iget2('b-edit-bid-control', 'max-s', 'max {foo}', {
                foo: maxValue
            });
        }
    },

    value: {
        type: 'blank-number2',
        precision: 0,
        'default': '',
        validation: {
            rules: {
                gte: {
                    needToValidate: function(value) {
                        // групповой инпут проверять не надо
                        return !this.get('isCommon');
                    },
                    value: function() {
                        return this.get('maxValue');
                    },
                    text: function() {
                        return this.get('mode') == 'up' ?
                            iget2('b-edit-bid-control', 'nelzya-uvelichit-cenu-klika', 'Нельзя увеличить цену клика более чем на {foo}%', {
                                foo: this.get('maxValue')
                            }) :
                            iget2('b-edit-bid-control', 'nelzya-umenshit-cenu-klika', 'Нельзя уменьшить цену клика более чем на {foo}%', {
                                foo: this.get('maxValue')
                            });
                    }
                },

                integerAndPositive: {
                    validate: function(value) {

                        return value >= 0;
                    },
                    text: iget2('b-edit-bid-control', 'znachenie-dolzhno-byt-celym', 'Значение должно быть целым положительным числом')
                }
            }
        }
    }
});
