/**
 * @event b-edit-region-bid#save
 * @type {Object}
 * @property {Number} value значение ставки
 * @property {('up'|'down'|'noValue')} mode
 * @property {Number} absValue абсолютное значение ставки
 *
 * @fires b-edit-region-bid#save событие сохранения выбранных параметров
 * @fires b-edit-region-bid#cancel событие нажатия на кнопку Отмена
 */
BEM.DOM.decl({ name: 'b-edit-region-bid' }, {
    onSetMod: {
        js: function() {
            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._saveBtn = this.findBlockInside('save', 'button');
            this._cancelBtn = this.findBlockInside('cancel', 'button');
            this._editBidControl = this.findBlockInside('b-edit-bid-control');

            this._subscriptionManager.on(this._saveBtn, 'click', this._onSaveButtonClick, this);
            this._subscriptionManager.on(this._cancelBtn, 'click', this._onCancelButtonClick, this);

            this._subscriptionManager.wrap(this._editBidControl)
                .on('change', this._onEditBidControlChange, this)
                .on('validated', function(event, validation) {
                    if (validation.errors) {
                        this._showErrors(validation.errors);
                    } else {
                        this._hideErrors();
                    }

                    this._saveBtn.setMod('disabled', validation.errors ? 'yes' : '');
                }, this);

            // enter по одному из полей формы должен ее сабмитить,
            // но реальный пост запрос отправлять не надо
            this.bindTo(this.elem('form'), 'submit', function(e) {
                e.preventDefault();
            });
        },

        focused: {
            'yes': function() {
                this._editBidControl.setMod('focused', 'yes');
            }
        }
    },

    /**
     * Удаляет блок и подписки на события
     */
    destruct: function() {
        this._subscriptionManager.dispose();

        return this.__base.apply(this, arguments);
    },

    /**
     * Обработчик события изменения котрола редактирования ставки
     */
    _onEditBidControlChange: function() {
        this._saveBtn.setMod('disabled', this.params.value == this._editBidControl.getData().value ? 'yes' : '');
    },

    /**
     * Обработчик события нажатия на кнопку OK
     */
    _onSaveButtonClick: function() {
        this.trigger('save', this._editBidControl.getData());
    },

    /**
     * Обработчик события нажатия на кнопку Отмена
     */
    _onCancelButtonClick: function() {
        this.trigger('cancel');
    },

    /**
     * Показывает ошибки валидации
     * @param {Object[]} errors
     * @param {String} errors[].text
     * @param {String} errors[].rule
     */
    _showErrors: function(errors) {
        var errorTexts = errors.reduce(function(res, error) {
                res[error.rule] = error.text;

                return res;
            }, {}),
            errorText;

        errorText = errorTexts.integerAndPositive || u._.values(errorTexts).join('. ')

        this.elem('error-text').text(errorText);
        this.delMod(this.elem('error'), 'hidden');
    },

    /**
     * Скрывает ошибки валидации
     */
    _hideErrors: function() {
        this.elem('error-text').text('');
        this.setMod(this.elem('error'), 'hidden', 'yes');
    }
});
