/**
 * Блок отображения сообщения с текстом ошибок. Сообщение прячется под "одноразовый" кат
 * @implements IErrorViewInterface
 * {Object} this.params
 * {String} this.params.cutText текст ката
 */
BEM.DOM.decl({ block: 'b-error-message', modName: 'has-cut', modVal: 'yes' }, {

    /**
     * Показывает ошибки
     * @param {CommonErrorData[]} errors
     */
    showErrors: function(errors) {
        var errorsTexts = u._.unique(errors.map(function(error) {
                return error.description || error.text;
            })),
            content = [
                {
                    block: 'b-error-message',
                    elem: 'text',
                    content: this.params.title
                },
                {
                    block: 'b-cut',
                    mods: { 'one-time': 'yes' },
                    content: [
                        {
                            block: 'link',
                            mods: {
                                pseudo: 'yes'
                            },
                            mix: [{
                                block: 'b-cut',
                                elem: 'link'
                            }],
                            content: this.params.cutText
                        },
                        {
                            block: 'b-cut',
                            elem: 'content',
                            content: errorsTexts.map(function(errorText) {
                                return {
                                    block: 'b-error-message',
                                    elem: 'text',
                                    content: u.escapeHTML(errorText)
                                };
                            })
                        }
                    ]
                }
            ];

        BEM.DOM.update(this.domElem, BEMHTML.apply(content));

        this.setMod('visible', 'yes');
    }
});
