/**
 * Блок отображения сообщения с текстом ошибок
 * @implements IErrorViewInterface
 */
BEM.DOM.decl({ block: 'b-error-message', implements: 'i-error-view-interface' }, {

    /**
     * Показывает ошибки
     * @param {CommonErrorData[]} errors
     */
    showErrors: function(errors) {
        var errorsTexts = u._.unique(errors.map(function(error) {
            return error.description || error.text;
        }));

        BEM.DOM.update(this.domElem, BEMHTML.apply(errorsTexts.map(function(error) {
            return {
                block: 'b-error-message',
                elem: 'text',
                content: u.escapeHTML(error)
            };
        })));

        this.setMod('visible', 'yes');
    },

    /**
     * Сбрасывает ошибки
     */
    clearErrors: function() {
        BEM.DOM.update(this.domElem, '');

        this.delMod('visible');
    }

});
