/**
 * Блок отображения списка сообщений об ошибках c возможностью скрытия/показа всего списка
 * @implements IErrorViewInterface
 */
BEM.DOM.decl({ block: 'b-error-pretty-message', modName: 'toggleable', modVal: 'yes' }, {

    _onToggleEnd: function(event) {
        this.elem('error-container-toggle').text(
            this._getExpandable().hasMod('collapsed', 'yes') ?
                iget2('b-error-pretty-message', 'minimize', 'скрыть') :
                iget2('b-error-pretty-message', 'details', 'подробнее')
        );
    },

    _getExpandable: function() {
        return this._expandable || (this._expandable = this.findBlockInside('m-expandable'));
    },

    _updateErrorContainer: function(errorItems) {
        var leftErrors = errorItems.slice(1);

        BEM.DOM.update(this.elem('error-container-header'), BEMHTML.apply(errorItems.slice(0, 1)));
        BEM.DOM.update(this.elem('error-container-expander'), BEMHTML.apply(leftErrors));

        this.setMod(this.elem('error-container'), 'visible', u._.isEmpty(leftErrors) ? '' : 'yes');
        this.setMod('visible', u._.isEmpty(errorItems) ? '' : 'yes');
    }
},{
    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'link', function(e) {
            if (this.elem('error-container-toggle').is(e.target.domElem)){
                this._onToggleEnd(e);
            }
        });
    }
});
