/**
 * Блок отображения сообщения с текстом ошибок
 * @implements IErrorViewInterface
 */
BEM.DOM.decl({ block: 'b-error-pretty-message', implements: 'i-error-view-interface' }, {

    /**
     * Показывает ошибки
     * @param {CommonErrorData[]} errors
     */
    showErrors: function(errors) {
        var iconMods = this._getIconTextMods(),
            errorsTexts = u._.unique(errors.map(function(error) {
                return error.description || error.text;
            }));

        this._updateErrorContainer(
            errorsTexts.map(function(error) {
                return this._applyIconTextBlock(error, iconMods);
            }, this)
        );
    },

    _applyIconTextBlock: function(error, iconMods) {
        return {
            block: 'icon-text',
            mix: { block: 'b-error-pretty-message', elem: 'line' },
            mods: iconMods,
            text: {
                block: 'b-error-pretty-message',
                elem: 'text',
                content: error
            }
        };
    },


    _updateErrorContainer: function(errorItems) {
        BEM.DOM.update(this.domElem, BEMHTML.apply(errorItems));

        this.setMod('visible', u._.isEmpty(errorItems) ? '' : 'yes');
    },

    _getIconTextMods: function() {
        return {
            size: 'xs',
            theme: 'notice'
        };
    },

    /**
     * Сбрасывает ошибки
     */
    clearErrors: function() {
        this._updateErrorContainer([]);
    }

});
