BEM.DOM.decl({ block: 'b-error-tooltip', modName: 'highlight', modVal: 'input-red-border' }, {

    onSetMod: {

        highlighted: {

            yes: function() {
                this._getInput() && this._getInput()
                    .setMod('highlight-border', 'red')
                    .onFirst('change', this.clearErrors, this);
            },

            '': function() {
                this._getInput() && this._getInput().delMod('highlight-border');

                this._hideErrorTooltip();
            }

        }

    },

    /**
     * Возвращает экземпляр блока `input`
     * @return {BEM.DOM}
     * @private
     */
    _getInput: function() {
        return this._input || (this._input = this.findBlockInside('input'));
    },

    /**
     * Отображает ошибки и подсвечивает инпут
     */
    showErrors: function() {
        this.__base.apply(this, arguments);

        this.setMod('highlighted', 'yes');
    },

    /**
     * Сбрасывает ошибки
     */
    clearErrors: function() {
        this.__base.apply(this, arguments);

        this.delMod('highlighted');
    },

    /**
     * Обработчик событий
     * @param {jQuery.Event} e
     * @private
     */
    _onMouseOverOutError: function(e) {
        if (e.type === 'pointerover') {
            this._showErrorTooltip({ source: 'pointerEvents' });
        } else {
            this._hideErrorTooltip();
        }
    },

    destruct: function() {
        this._getInput() && this._getInput().un('change', this.clearErrors, this);

        this.__base.apply(this, arguments);
    }

}, {

    live: function() {
        this.liveBindTo(
            { modName: 'highlighted', modVal: 'yes' },
            'pointerover pointerout',
            function(e, data) {
                this._onMouseOverOutError(e, data);
            }
        );

        return this.__base.apply(this, arguments);
    }

});
