/**
 * Событие перед показом тултипа
 * @event b-error-tooltip#before-show
 * @type {Object}
 * @property {'showErrors'|'pointerEvents'|string} source Что вызвало показ тултипа
 */

/**
 * Событие показа тултипа
 * @event b-error-tooltip#show
 */

/**
 * Событие закрытия тултипа
 * @event b-error-tooltip#hide
 */

/**
 * @fires b-error-tooltip#before-show
 * @fires b-error-tooltip#show
 * @fires b-error-tooltip#hide
 */

BEM.DOM.decl({ block: 'b-error-tooltip', implements: 'i-error-view-interface' }, {

    onSetMod: {
        js: function() {
            var defaultParams = this._getDefaultParams();

            this._params = u._.assign(
                defaultParams,
                u._.pick(this.params, Object.keys(defaultParams)),
                this.params.hasOwnProperty('delay') ? { delay: this.params.delay } : {}
            );
        }
    },

    /**
     * Отображает ошибки
     * @param {{description:string, text:string}[]} errors
     * @param {string} [source='showErrors'] параметр который будет в событии `before-show`
     */
    showErrors: function(errors, source) {
        this._errors = u._.unique(errors.map(function(error) {
            return error.description || error.text;
        }));

        this._showErrorTooltip({ source: source || 'showErrors' });
    },

    /**
     * Сбрасывает ошибки
     */
    clearErrors: function() {
        this._errors = null;

        this._hideErrorTooltip()
    },

    /**
     * Возвращает набор параметров по умолчанию
     * @return {{tooltipMods: object, tooltipDirections: string[], tooltipContentMix: [object], delay: [number]}}
     * @private
     */
    _getDefaultParams: function() {
        return {
            tooltipMods: { theme: 'normal', type: 'direct' },
            tooltipDirections: ['bottom', 'top'],
            tooltipContentMix: false,
            needTail: false,
            offset: 20,
            delay: 0
        };
    },

    /**
     * Возвращает
     * @return {*}
     * @private
     */
    _getOwner: function() {
        var ownerElem = this.findElem('owner');

        return ownerElem.length ? ownerElem : this.domElem;
    },

    /**
     * Отображает подсказку с ошибкой
     * @param {Object} beforeShowParams Параметры для события `before-show`
     * @private
     */
    _showErrorTooltip: function(beforeShowParams) {
        var beforShowEvent = $.Event('before-show');

        this.trigger(beforShowEvent, beforeShowParams);

        if (!beforShowEvent.isDefaultPrevented()) {
            this._getTooltip().show({
                owner: this._getOwner(),
                content: function() {
                    return BEMHTML.apply({
                        block: 'b-error-tooltip',
                        mods: u._.omit(this.getMods(), 'js'),
                        elem: 'content',
                        mix: this._params.tooltipContentMix,
                        content: this._errors.map(function(error) {
                            return { elem: 'text', content: u.escapeHTML(error) }
                        })
                    });
                }.bind(this)
            });
        }
    },

    /**
     * Возвращает экземпляр блока `tooltip`
     * @return {BEM.DOM}
     * @private
     */
    _getTooltip: function() {
        if (!this._tipman) {
            this._tipman = BEM.create('tipman', {
                tipMods: this._params.tooltipMods,
                popupDirections: this._params.tooltipDirections,
                needTail: this._params.needTail,
                offset: this._params.offset,
                delay: this._params.delay
            })
                .on(
                    { modName: 'shown' },
                    function(e, data) { this.trigger(data.modVal ? 'show' : 'hide') },
                    this
                );
        }

        return this._tipman;
    },

    /**
     * Прячет подсказку
     * @private
     */
    _hideErrorTooltip: function() {
        this._tipman && this._tipman.hide();
    },

    destruct: function() {
        this._tipman && this._tipman.destruct();

        return this.__base.apply(this, arguments);
    }

}, {

    live: true

});
