u.register({
    'b-errors-presenter2': {
        /**
         * Разбивает путь на массив
         * u['b-errors-presenter2'].toPath('a.b[0].c') => ['a', 'b', '0','c']
         * Аналог lodash@4 _.toPath
         * @param {String} path
         * @returns {String[]}
         */
        toPath: function(path) {
            return path.replace(/(\[(\d+)\])+?/g, '.$2').split('.');
        },

        /**
         * Собирает `path` из массива
         * u['b-errors-presenter2'].joinPath(['a', 'b', '0','c']) => 'a.b.0.c';
         * @param {String[]} pathArray
         * @returns {String}
         */
        joinPath: function(pathArray) {
            return pathArray.join('.');
        },

        /**
         * Преобразует `path` из `lodash` в формат использующийся в блоке
         * u['b-errors-presenter2'].formatPath('a.b[0].c') => 'a.b.0.c';
         * @param {String} origPath
         * @param {Object} [map] Объект соответствий
         * @returns {String}
         */
        formatPath: function(origPath, map) {
            return u['b-errors-presenter2'].joinPath(
                map ?
                    u['b-errors-presenter2'].toPath(origPath).map(function(origPathPart) {
                        return map[origPathPart] || origPathPart;
                    }) :
                    u['b-errors-presenter2'].toPath(origPath)
            );
        },

        /**
         * Собирает `path` передвигаясь по родителям до `vanilaParent`
         * @param {HTMLElement} current
         * @param {HTMLElement} parent
         * @return {string[]}
         */
        getPathFromDom: function(current, parent) {
            if (current === parent) {
                return [];
            }

            var path = current.dataset.errPath;

            return u._.isUndefined(path) ?
                u['b-errors-presenter2'].getPathFromDom(current.parentNode, parent) :
                u['b-errors-presenter2'].getPathFromDom(current.parentNode, parent).concat(path);
        }
    }
});
