/**
 * @param {String} [ctx.title] заголовок блока
 * @param {String} [ctx.placeholder] placeholder для поля ввода ссылки
 **/
block('b-external-file-uploader')(
    js()(true),

    content()(function() {
        return {
            elem: 'controls',
            content: [
                {
                    elem: 'input',
                    placeholder: this.ctx.placeholder
                }
            ]
        }
    }),

    elem('input').def()(function() {
        return applyCtx({
            block: 'input',
            mods: {
                autoFocus: this.ctx.autoFocus ? 'yes' : ''
            },
            mix: {
                block: 'b-external-file-uploader',
                elem: 'input'
            },
            content: [
                {
                    elem: 'control',
                    attrs: {
                        placeholder: this.ctx.placeholder || iget2('b-external-file-uploader', 'adres', 'Адрес')
                    }
                },
                {
                    elem: 'message',
                    mix: {
                        block: 'b-external-file-uploader',
                        elem: 'error-message'
                    },
                    elemMods: {
                        visibility: 'visible',
                        type: 'error'
                    }
                }
            ]
        });
    })
);
