/**
 * @event b-external-file-uploader#save
 * @type {Object}
 * @property {String} value сохраненное значение ссылки
 *
 * @fires b-external-file-uploader#save событие успешного сохранения ссылки
 */
BEM.DOM.decl({ name: 'b-external-file-uploader' }, {
    onSetMod: {
        js: function() {
            this.resetForm();

            this._getInput().on('change', this._onInputChange, this);
        }
    },

    /**
     * Показывает ошибки валидации
     * @param {String} message текст ошибки
     */
    showErrors: function(message) {
        this.elem('error-message').text(message);
    },

    /**
     * Возвращает контролы формы к исходному состоянию
     */
    resetForm: function() {
        this._getInput().val('');

        this._clearErrors();
    },

    /**
     * Выполняет сохранение значения ссылки с предварительной валидацией
     * @private
     */
    save: function() {
        var validationResult = this.validate();

        if (validationResult.isValid) {
            this.trigger('save', {
                value: this._inputControl.val()
            });
        }
    },

    /**
     * Проверяет пусто ли поле ввода
     * @returns {boolean}
     */
    isEmpty: function() {
        return this.getValue() === '';
    },

    /**
     * Возвращает значение контролла
     * @returns {String}
     */
    getValue: function() {
        return this._inputControl.val().trim();
    },

    /**
     * Устанавливает значение контролла
     * @param {String} val
     * @returns {BEM}
     */
    setValue: function(val) {
        this._inputControl.val(val);

        return this;
    },

    /**
     * Деструктор
     * @returns {*}
     */
    destruct: function() {
        this._getInput().un('change');

        return this.__base.apply(this, arguments);
    },

    _getInput: function() {
        return this._inputControl || (this._inputControl = this.findBlockOn('input', 'input'));
    },

    /**
     * Изменение значения в инпуте
     * @private
     */
    _onInputChange: function() {
        this.trigger('change');

        this._clearErrors();
    },

    /**
     * Скрывает ошибки валидации
     * @private
     */
    _clearErrors: function() {
        this.elem('error-message').text('');
    },

    /**
     * Валидирует значение поля
     * @returns {Object}
     * @private
     */
    validate: function() {
        var val = this._getInput().val().trim(),
            validationResult = {
                isValid: true
            };

        if (u.isEmpty(val)) {
            validationResult = {
                isValid: false,
                error: 'required',
                message: iget2('b-external-file-uploader', 'ukazhite-ssylku', 'Укажите ссылку')
            }
        } else if (!u.isUrl(val)) {
            validationResult = {
                isValid: false,
                error: 'pattern',
                message: iget2('b-external-file-uploader', 'ukazana-nekorrektnaya-ssylka', 'Указана некорректная ссылка')
            }
        }

        if (!validationResult.isValid) {
            this.showErrors(validationResult.message);
        }

        return validationResult;
    }
});
