BEM.DOM.decl({ block: 'b-hintable', modName: 'hoverable', modVal: 'yes'}, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._delay = 100;
            this._popupHovered = false;
            this._elemHovered = false;
        }
    },

    /**
     * Обновляет содержимое попапа подсказки
     */
    _updateHintContent: function() {
        this._getHintPopup().setContent(this._hint);
    },

    /**
     * Меняет видимость подсказки
     * @param {Object} event -  объкт события
     */
    _toggleHint: function(event) {
        var type = event.type,
            isPopupHovered = this._getHintPopup().domElem.is($(event.currentTarget));

        if (type === 'mouseenter') {
            if (isPopupHovered) {
                this._popupHovered = true;
            } else {
                this._elemHovered = true;
                this.bindTo(this._getHintPopup().domElem, 'mouseenter mouseleave', this._toggleHint.bind(this));
            }
            !this._getHintPopup().isShown() && this._showHint();
        } else if (type === 'mouseleave') {
            isPopupHovered ? this._popupHovered = false : this._elemHovered = false;
            this._hideHint();
        }
    },

    /**
     * Показывает предупреждающий хинт, если задан не пустой текст для него
     * @private
     */
    _showHint: function() {
        if (!this._hint) { return; }
        if (!this._hint || this.getMod('disabled') == 'yes') { return; }

        this._updateHintContent();

        this._getHintPopup().isShown() || this._getHintPopup().show(this.domElem);
    },

    /**
     * Прячет хинт
     * @private
     */
    _hideHint: function() {
        this._delay && setTimeout(function() {
            if (!this._popupHovered && !this._elemHovered) {
                this.unbindFrom(this._getHintPopup().domElem, 'mouseenter mouseleave');
                this._getHintPopup().isShown() && this._getHintPopup().hide();
            }
        }.bind(this), this._delay);
    }
});
