BEM.DOM.decl('b-hintable', {
    onSetMod: {
        js: function() {
            this._hint = this.params.hint || '';
            this._directions = this.params.directions || ['right', 'left'];
            this._onScroll  =  this.params.onScroll || '';

            this.bindTo(this.domElem, 'mouseenter mouseleave', this._toggleHint.bind(this));
        }
    },

    /**
     * Устанавливает новый текст подсказки
     * @param {String|HTML|jQuery} content - текст подсказки или DOM элемент
     */
    setHintContent: function(content) {
        this._hint = content;
        this._updateHintContent();
    },

    /**
     * Прячет хинт
     * @private
     */
    hideHint: function() {
        this._hideHint();
    },

    /**
     * Обновляет содержимое попапа подсказки
     */
    _updateHintContent: function() {
        this._getHintPopup().setContent(this._hint);
    },

    /**
     * Меняет видимость подсказки
     * @param {Object} event -  объкт события
     */
    _toggleHint: function(event) {
        if (event.type === 'mouseenter') {
            this._showHint();
        } else if (event.type === 'mouseleave') {
            this._hideHint();
        }
    },

    /**
     * Показывает предупреждающий хинт, если задан не пустой текст для него
     * @private
     */
    _showHint: function() {
        if (!this._hint) { return; }
        if (!this._hint || this.getMod('disabled') == 'yes') { return; }

        this._updateHintContent();

        this._getHintPopup().show(this.domElem);
    },

    /**
     * Прячет хинт
     * @private
     */
    _hideHint: function() {
        this._getHintPopup().hide();
    },

    /**
     * Возвращает блок попап для показа подсказки об ошибке
     * @returns {BEM}
     */
    _getHintPopup: function() {
        this.popup ||
            (this.popup = $(BEMHTML.apply({
                block: 'popup',
                mix: [{ block: 'b-hintable', elem: 'popup' }],
                mods: { 'on-scroll': this._onScroll },
                js: { directions: this._directions },
                content: [{ elem: 'tail', mix: { block: 'b-hintable', elem: 'tail' } }, { elem: 'content', mix: { block: 'b-hintable', elem: 'hint-content' } }]
            })).appendTo(document.body).bem('popup'));

        return this.popup;
    },

    /**
     * Уничтожает блок
     * @returns {BEM.DOM}
     */
    destruct: function() {
        this.popup && this.popup.destruct();
        this.__base();
    }
});
