describe('b-modal-popup-decorator', function() {

    var sandbox = sinon.sandbox.create({ useFakeTimers: true });

    afterEach(function() {
        sandbox.restore();
    });

    describe('Проксирование методов и установка контента', function() {
        var block;

        beforeEach(function() {
            block = BEM.DOM.blocks['b-modal-popup-decorator'].create();

            sandbox.spy(block, 'trigger');
            sandbox.spy(block, 'hide');
        });

        afterEach(function() {
            block.destruct();
        });

        describe('декорируемый блок `popup`', function() {

            it('получаем через вызов getPopup()', function() {
                expect(block.getPopup()).to.be.an.instanceof(BEM.DOM.blocks['popup']);
            });

            ['before-hide'].forEach(function(event) {

                // cyn@TODO какой-то совсем плохой тест, нужно бы переписать
                describe.skip('триггерит событие `' + event + '`', function() {

                    if (event == 'outside-click') {

                        it('то блок триггерит `' + event + '`', function() {
                            block.getPopup().trigger(event);

                            expect(block).to.triggerEvent(event);
                        });

                        it('то не вызывается hide(), если событие было остановлено', function() {
                            block.onFirst(event, function(e) { e.preventDefault(); });
                            block.getPopup().trigger(event);

                            expect(block.hide.called).to.be.false;
                        });
                    }

                    it('то у блока вызывается hide()', function() {
                        block.getPopup().trigger(event);

                        expect(block.hide.called).to.be.true;
                    });

                });

            });

            describe('триггерит событие `hide`', function() {

                it('то блок триггерит `close`', function() {
                    block.getPopup().trigger('hide');

                    expect(block).to.triggerEvent('close');
                });

            });

        });

        ['show', 'toggle', 'isShown'].forEach(function(method) {

            describe('вызов ' + method + '()', function() {

                beforeEach(function() {
                    sandbox.spy(block.getPopup(), method);

                    block[method]();
                });

                it('вызывает у попапа ' + method + '()', function() {
                    expect(block.getPopup()[method].called).to.be.true;
                });

            });

        });

        describe('вызов setPopupContent(content)', function() {

            it('кидает исключение, если content не содержит блок с интерфейсом i-modal-popup-inner-block-interface', function() {
                expect(function() { block.setPopupContent({ block: 'block-without-i-modal-popup-inner-block-interface' }); })
                    .to.throw(Error, 'Couldn\'t find block with interface \'i-modal-popup-inner-block-interface\'');
            });

            it('не кидает исключение, если content содержит блок с интерфейсом i-modal-popup-inner-block-interface', function() {
                BEM.DOM.decl({ block: 'block-with-i-modal-popup-inner-block-interface', implements: 'i-modal-popup-inner-block-interface' }, {
                    isChanged: function() {}
                });

                expect(function() { block.setPopupContent({ block: 'block-with-i-modal-popup-inner-block-interface' }); })
                    .to.not.throw(Error);
            });

        });

    });

    describe('при setPopupContent(content) + show()', function() {
        var block,
            innerBlock,
            changes;

        beforeEach(function() {
            BEM.DOM.decl({ block: 'block-with-i-modal-popup-inner-block-interface', implements: 'i-modal-popup-inner-block-interface' }, {
                isChanged: sandbox.spy(function() {
                    return $.Deferred(function(deferred) {
                        deferred.resolve(!u._.isEmpty(changes));
                    });
                })
            });

            block = BEM.DOM.blocks['b-modal-popup-decorator'].create();

            sandbox.spy(block, 'trigger');

            innerBlock = block.setPopupContent({ block: 'block-with-i-modal-popup-inner-block-interface' });

            block.show();

            sandbox.clock.tick(1000); // может быть анимация

            sandbox.spy(block.getPopup(), 'hide');
        });

        afterEach(function() {
            block.destruct();
        });

        describe('если нет изменений', function() {
            before(function() {
                changes = [];
            });

            describe('то при hide()', function() {

                beforeEach(function() {
                    block.hide();

                    sandbox.clock.tick(1000); // может быть анимация
                });

                it('isChanged внутреннего блока вызывается', function() {
                    expect(innerBlock.isChanged.called).to.be.true;
                });

                it('у попапа вызывается hide()', function() {
                    expect(block.getPopup().hide.called).to.be.true;
                });

                it('триггерится событие close', function() {
                    expect(block).to.triggerEvent('close');
                });

                it('попап закрыт', function() {
                    expect(block.isShown()).to.be.false;
                });

            });

        });

        describe('если есть изменения, то при hide()', function() {
            before(function() {
                changes = ['changes1', 'changes2'];
            });

            beforeEach(function() {
                block.hide();

                sandbox.clock.tick(1000); // может быть анимация
            });

            it('isChanged внутреннего блока вызывается', function() {
                expect(innerBlock.isChanged.called).to.be.true;
            });

            it('у попапа не вызывается hide() c параметром `{ source: \'force\' }`', function() {
                expect(block.getPopup().hide.calledWith({ source: 'force' })).to.be.false;
            });

            it('триггерится событие close-blocked', function() {
                expect(block).to.triggerEvent('close-blocked');
            });

            it('попап не закрыт', function() {
                expect(block.isShown()).to.be.true;
            });

        });

    });

    describe('b-modal-popup-decorator_type_direct', function() {
        describe('Установка опциональных модификаторов блока', function() {
            describe('Модификатор body-scroll', function() {
                var block;

                afterEach(function() {
                    block.destruct();
                });

                it('По умолчанию модификатор не ставится', function() {
                    block = BEM.DOM.blocks['b-modal-popup-decorator'].create();

                    expect(block.getPopup()).not.to.haveMod('body-scroll');
                });

                it('По параметре bodyScroll: true модификатор не ставится', function() {
                    block = BEM.DOM.blocks['b-modal-popup-decorator'].create(undefined, { bodyScroll: true });

                    expect(block.getPopup()).not.to.haveMod('body-scroll');
               });

                it('При параметре bodyScroll: false ставится body-scroll: no', function() {
                    block = BEM.DOM.blocks['b-modal-popup-decorator'].create(undefined, { bodyScroll: false });

                    expect(block.getPopup()).to.haveMod('body-scroll', 'no');
                })
            });

            describe('Модификатор child-state', function() {
                var block;

                afterEach(function() {
                    block.destruct();
                });

                it('По умолчанию модификатор не ставится', function() {
                    block = BEM.DOM.blocks['b-modal-popup-decorator'].create();

                    expect(block.getPopup()).not.to.haveMod('child-state');
                });

                it('При параметре childState: true модификатор ставится в значение yes', function() {
                    block = BEM.DOM.blocks['b-modal-popup-decorator'].create(undefined, { childState: true });

                    expect(block.getPopup()).to.haveMod('child-state', 'yes');
                });

                it('При параметре childState: false модификатор не ставится', function() {
                    block = BEM.DOM.blocks['b-modal-popup-decorator'].create(undefined, { childState: false });

                    expect(block.getPopup()).not.to.haveMod('child-state');
                })
            })
        });

    })

});
