/**
 * {object} this.parmas
 * {Number} [this.params.bleachHeight=20] высота засветов
 */
BEM.DOM.decl('b-overflow-luxury-scroll', {

    onSetMod: {

        js: function() {
            this.afterCurrentEvent(function() {
                this._blockHeight = this.domElem.height();
                this._contentHeight = this.elem('content').height();
                this._contentWidth = this.elem('content').width();
                this._scrollTop = this.elem('overflow').scrollTop();

                this._bleachHeight = this.params.bleachHeight || 20;

                BEM.blocks['resize-watcher'].getInstance({ owner: this, ignoreWidth: true })
                    .on('change', this._onBlockHeightChange, this);

                BEM.blocks['resize-watcher'].getInstance({ owner: this.elem('content') })
                    .on('change', this._onContentSizeChange, this);

                this.bindTo('overflow', 'scroll', $.throttle(this._onScroll, 100, this));

                this._calc();
            });
        }

    },

    onElemSetMod: {

        bleach: {

            visible: {

                yes: function(elem, modName, modVal) {
                    elem.css({
                        height: this._bleachHeight,
                        width: this._contentWidth
                    });
                },

                '': function(elem) {
                    elem.removeAttr('style')
                }
            }

        }

    },

    /**
     * Обработчик изменения размеров блока
     * @param {jQuery.Event} e
     * @param {object} data
     * @param {number} data.height
     * @private
     */
    _onBlockHeightChange: function(e, data) {
        this._blockHeight = data.height;

        this._calc();
    },

    /**
     * Обработчик изменения размеров элемента с контентом
     * @param {jQuery.Event} e
     * @param {object} data
     * @param {number} data.height
     * @param {number} data.width
     * @private
     */
    _onContentSizeChange: function(e, data) {
        this._contentWidth = data.width;
        this._contentHeight = data.height;

        this._calc();
    },

    /**
     * Обработчик скролла
     * @private
     */
    _onScroll: function() {
        this._scrollTop = this.elem('overflow').scrollTop();

        this._calc();
    },

    /**
     * Меняет позицию скролла на указанную
     * @param {number} scrollPos
     */
    scrollTo: function(scrollPos) {
        this.elem('overflow').scrollTop(scrollPos);
    },

    /**
     * Прячет/показывает засветы
     * @private
     */
    _calc: function() {
        if (this._blockHeight >= this._contentHeight) {
            this.delMod(this.elem('bleach'), 'visible');
        } else {
            this.setMod(
                this.elem('bleach', 'pos', 'top'),
                'visible',
                this._scrollTop > 0 ? 'yes' : ''
            );

            this.setMod(
                this.elem('bleach', 'pos', 'bottom'),
                'visible',
                this._contentHeight - this._scrollTop - this._blockHeight > 0 ? 'yes' : ''
            );
        }
    }

});
